/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.converters;

import com.opensymphony.xwork2.conversion.impl.NumberConverter;
import java.lang.reflect.Member;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.conversion.TypeConversionException;

public class LocalNumberConverter
extends NumberConverter {
    protected DecimalFormat integerFormat;
    protected DecimalFormat doubleFormat;

    protected DecimalFormat getIntegerFormat() {
        if (this.integerFormat == null) {
            this.integerFormat = new DecimalFormat("###,##0");
        }
        return this.integerFormat;
    }

    protected DecimalFormat getDoubleFormat() {
        if (this.doubleFormat == null) {
            String pattern = "###,##0." + StringUtils.repeat((String)"0", (int)this.getMinDecimals()) + StringUtils.repeat((String)"#", (int)(this.getMaxDecimals() - this.getMinDecimals()));
            this.doubleFormat = new DecimalFormat(pattern);
        }
        return this.doubleFormat;
    }

    public Object convertValue(Map<String, Object> context, Object target, Member member, String propertyName, Object value, Class toType) {
        Object result = toType == String.class && (value instanceof Double || value instanceof Integer) ? this.convertToString(value) : (value instanceof String && (toType == Double.class || toType == Double.TYPE || toType == Integer.class || toType == Integer.TYPE) ? this.convertToNumber((String)value, toType) : super.convertValue(context, target, member, propertyName, value, toType));
        return result;
    }

    protected String convertToString(Object value) {
        String string = value == null ? this.formatNullValue() : (value instanceof Integer ? this.getIntegerFormat().format(value) : this.getDoubleFormat().format(value));
        return string;
    }

    protected Number convertToNumber(String string, Class toType) {
        Number parsedValue;
        if (this.isNullValue(string)) {
            parsedValue = toType.isPrimitive() ? (Number)(toType == Double.TYPE ? (Number)0.0 : (Number)0) : (Number)null;
        } else {
            char groupingSeparator = this.getIntegerFormat().getDecimalFormatSymbols().getGroupingSeparator();
            if (Character.isSpaceChar(groupingSeparator)) {
                string = string.replaceAll(" ", "" + groupingSeparator);
            }
            try {
                if (toType == Double.class || toType == Double.TYPE) {
                    string = string.replace('.', this.getDoubleFormat().getDecimalFormatSymbols().getDecimalSeparator());
                    parsedValue = this.getDoubleFormat().parse(string).doubleValue();
                } else {
                    parsedValue = this.getIntegerFormat().parse(string).intValue();
                }
            }
            catch (NumberFormatException | ParseException e) {
                throw new TypeConversionException("unable to parse " + string, (Throwable)e);
            }
        }
        return parsedValue;
    }

    protected String formatNullValue() {
        return "";
    }

    protected boolean isNullValue(String string) {
        boolean isNullValue = StringUtils.isEmpty((CharSequence)string);
        return isNullValue;
    }

    protected int getMinDecimals() {
        return 0;
    }

    protected int getMaxDecimals() {
        return 3;
    }
}

