/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.user;

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.Language;
import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.services.security.UserRoleDto;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.AgrosystWebApplicationContext;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.util.StringUtil;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class UserAccount
extends AbstractAgrosystAction
implements Preparable {
    private static final long serialVersionUID = -6751756402587810749L;
    protected transient AgrosystWebApplicationContext context;
    protected transient UserService userService;
    protected Map<String, String[]> bannerMap;
    protected UserDto user;
    protected String password;
    protected String confirmPassword;
    protected List<UserRoleDto> userRoles;

    public void setContext(AgrosystWebApplicationContext context) {
        this.context = context;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void prepare() {
        UserDto currentUser = this.userService.getCurrentUser();
        this.user = new UserDto();
        Binder userDtoBinder = BinderFactory.newBinder(UserDto.class);
        userDtoBinder.copy((Object)currentUser, (Object)this.user, new String[0]);
        this.userRoles = this.authorizationService.getUserRoles(this.user.getTopiaId());
    }

    public UserDto getUser() {
        return Objects.requireNonNullElseGet(this.user, UserDto::new);
    }

    @Action(value="user-account-input")
    public String input() {
        this.initForInput();
        return "input";
    }

    protected void initForInput() {
        this.bannerMap = this.context.getBannersMap();
    }

    public void validate() {
        String email = this.user.getEmail();
        if (Strings.isNullOrEmpty((String)email)) {
            this.addFieldError("user.email", this.getText("user-account-error-email-required"));
        } else if (!StringUtil.isEmail((String)email)) {
            this.addFieldError("user.email", this.getText("user-account-error-email-invalid"));
        }
        if (this.userService.isEmailInUse(email, this.user.getTopiaId())) {
            this.addFieldError("user.email", this.getText("user-account-error-email-alreadyused"));
        }
        if (!com.google.common.base.Objects.equal((Object)this.password, (Object)this.confirmPassword)) {
            this.addFieldError("confirmPassword", this.getText("user-account-error-password-differents"));
        }
        if (Strings.isNullOrEmpty((String)this.user.getFirstName())) {
            this.addFieldError("authenticatedUser.firstName", this.getText("user-account-error-firstName-required"));
        }
        if (Strings.isNullOrEmpty((String)this.user.getLastName())) {
            this.addFieldError("authenticatedUser.lastName", this.getText("user-account-error-lastName-required"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.user.getItEmail()) && !this.userService.isValidEmail(this.user.getItEmail())) {
            this.addFieldError("user.itEmail", this.getText("user-account-error-email-notIt"));
        }
        if (this.hasErrors()) {
            this.initForInput();
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "user-account-input"})})
    public String execute() {
        this.user = this.userService.updateUser(this.user, this.password);
        this.refreshAuthenticatedUser();
        this.notificationSupport.authenticatedUserSaved(this.user);
        return "success";
    }

    public Map<String, String[]> getBannerMap() {
        return this.bannerMap;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public List<UserRoleDto> getUserRoles() {
        return this.userRoles;
    }

    public Map<RoleType, String> getRoleTypes() {
        return this.getEnumAsMap((Object[])RoleType.values());
    }

    public List<Language> getLanguages() {
        return Arrays.asList(Language.values());
    }

    public boolean isToutesCampagnes(UserRoleDto role) {
        return role.getEntity().getIdentifier() != null && (role.getType() == RoleType.DOMAIN_RESPONSIBLE || role.getType() == RoleType.GROWING_PLAN_RESPONSIBLE || role.getType() == RoleType.GS_DATA_PROCESSOR && role.getEntity().getCampaign() == null);
    }

    public boolean isRoleCampagne(UserRoleDto role) {
        return role.getEntity().getIdentifier() != null && role.getType() == RoleType.GS_DATA_PROCESSOR && role.getEntity().getCampaign() != null;
    }
}

