/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.species;

import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;

public class ListVarietiesJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(ListVarietiesJson.class);
    private static final long serialVersionUID = 5088194867807225637L;
    protected transient ReferentialService referentialService;
    protected transient String speciesId;
    protected transient String varietyId;
    protected transient String term;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setSpeciesId(String speciesId) {
        this.speciesId = speciesId;
    }

    public void setVarietyId(String varietyId) {
        this.varietyId = varietyId;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public String execute() {
        try {
            this.jsonData = this.referentialService.getVarietes(this.speciesId, this.term);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load varieties for speciesId '%s' and term '%s'", this.speciesId, this.term), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="list-graft-support-json")
    public String listGraftSupports() {
        try {
            this.jsonData = this.referentialService.getGraftSupports(this.speciesId, this.term);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load varieties graft support for term '%s'", this.term), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="list-graft-clone-json")
    public String listGraftClones() {
        try {
            this.jsonData = this.referentialService.getGraftClones(this.speciesId, this.varietyId, this.term);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load clones graft support for speciesId '%s, varietyId '%s and term '%s'", this.speciesId, this.varietyId, this.term), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }
}

