/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.security;

import fr.inra.agrosyst.api.services.referential.ImportResult;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.action.UploadedFilesAware;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

@Results(value={@Result(type="redirectAction", name={"input"}, params={"namespace", "/security", "actionName", "users-list", "importUsersAndRolesFileError", "true"})})
public class UsersAndRolesImport
extends AbstractAdminAction
implements UploadedFilesAware {
    private static final Log LOGGER = LogFactory.getLog(UsersAndRolesImport.class);
    private static final long serialVersionUID = 5338924873719324729L;
    protected transient UserService userService;
    protected File userFile;
    protected File rolesFile;

    public void setRolesFile(File rolesFile) {
        this.rolesFile = rolesFile;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setUserFile(File userFile) {
        this.userFile = userFile;
    }

    @Action(results={@Result(name={"success"}, type="redirectAction", params={"namespace", "/security", "actionName", "users-list"}), @Result(name={"error"}, type="redirectAction", params={"namespace", "/security", "actionName", "users-list"})})
    public String execute() throws Exception {
        boolean errors;
        block8: {
            ImportResult result;
            block7: {
                errors = false;
                if (this.userFile != null) {
                    this.checkIsAdmin();
                    try {
                        result = this.userService.importUsers((InputStream)new FileInputStream(this.userFile));
                        this.notificationSupport.userImported(result);
                    }
                    catch (Exception ex) {
                        errors = true;
                        this.notificationSupport.usersImportFailed(ex.getMessage());
                        if (!LOGGER.isErrorEnabled()) break block7;
                        LOGGER.error((Object)"Can't import user file", (Throwable)ex);
                    }
                }
            }
            if (this.rolesFile != null) {
                this.checkIsAdmin();
                try {
                    result = this.authorizationService.importRoles((InputStream)new FileInputStream(this.rolesFile));
                    this.notificationSupport.userRolesUpdated(result);
                }
                catch (Exception ex) {
                    errors = true;
                    this.notificationSupport.rulesImportFailed(ex.getMessage());
                    if (!LOGGER.isErrorEnabled()) break block8;
                    LOGGER.error((Object)"Can't import roles file", (Throwable)ex);
                }
            }
        }
        if (errors) {
            return "error";
        }
        return "success";
    }

    public void withUploadedFiles(List<UploadedFile> uploadedFiles) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("L'utilisateur %s \u00e0 soumis %d ficher de r\u00f4les ou utilisateurs", this.getAuthenticatedUser().getEmail(), CollectionUtils.emptyIfNull(uploadedFiles).size()));
        }
    }
}

