/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.security;

import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.security.UserRoleDto;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import fr.inra.agrosyst.web.actions.security.EditEntityRolesRaw;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EditEntityRolesRaw
extends AbstractAgrosystAction {
    private static final long serialVersionUID = -8587272104576117396L;
    protected transient GrowingSystemService growingSystemService;
    protected RoleType roleType;
    protected String entityCode;
    protected List<UserRoleDto> roles;
    protected List<Integer> availableCampaigns;

    public void setGrowingSystemService(GrowingSystemService growingSystemService) {
        this.growingSystemService = growingSystemService;
    }

    public void setRoleType(RoleType roleType) {
        this.roleType = roleType;
    }

    public void setEntityCode(String entityCode) {
        this.entityCode = entityCode;
    }

    public String execute() throws Exception {
        this.readOnly = true;
        switch (1.$SwitchMap$fr$inra$agrosyst$api$entities$security$RoleType[this.roleType.ordinal()]) {
            case 1: {
                this.readOnly = !this.authorizationService.isDomainAdministrable(this.entityCode);
                break;
            }
            case 2: {
                this.readOnly = !this.authorizationService.isGrowingPlanAdministrable(this.entityCode);
                break;
            }
            case 3: {
                this.readOnly = !this.authorizationService.isGrowingSystemAdministrable(this.entityCode);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected role type: " + String.valueOf(this.roleType));
            }
        }
        this.roles = this.authorizationService.getEntityRoles(this.roleType, this.entityCode);
        this.availableCampaigns = RoleType.GS_DATA_PROCESSOR.equals((Object)this.roleType) ? this.growingSystemService.getGrowingSystemCampaigns(this.entityCode) : new ArrayList();
        return "success";
    }

    public RoleType getRoleType() {
        return this.roleType;
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    public List<UserRoleDto> getRoles() {
        return this.roles;
    }

    public List<Integer> getAvailableCampaigns() {
        return this.availableCampaigns;
    }

    public Map<RoleType, String> getRoleTypes() {
        return this.getEnumAsMap((Object[])RoleType.values());
    }
}

