/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.reports;

import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.referential.BioAgressorParentType;
import fr.inra.agrosyst.api.entities.referential.Referentials;
import fr.inra.agrosyst.api.entities.report.ReportRegional;
import fr.inra.agrosyst.api.entities.report.ReportRegionalImpl;
import fr.inra.agrosyst.api.services.referential.GroupeCibleDTO;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.api.services.report.ReportService;
import fr.inra.agrosyst.api.services.users.AuthenticatedUser;
import fr.inra.agrosyst.web.actions.reports.AbstractReportAction;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class ReportRegionalEdit
extends AbstractReportAction
implements Preparable {
    private static final long serialVersionUID = -6750424949212885687L;
    protected ReportRegional reportRegional;
    protected transient ReportService reportService;
    protected transient ReferentialService referentialService;
    protected String reportRegionalTopiaId;
    protected List<String> reportRegionalNetworkIds;
    protected String pestPressuresJson;
    protected String diseasePressuresJson;
    protected Set<String> networkIdsUsed;
    protected List<GroupeCibleDTO> groupesCibles;
    protected LinkedHashMap<Integer, String> relatedReportRegionals;

    public ReportRegional getReportRegional() {
        return Objects.requireNonNullElseGet(this.reportRegional, ReportRegionalImpl::new);
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setReportRegionalTopiaId(String reportRegionalTopiaId) {
        this.reportRegionalTopiaId = reportRegionalTopiaId;
    }

    public void setReportRegionalNetworkIds(List<String> reportRegionalNetworkIds) {
        this.reportRegionalNetworkIds = reportRegionalNetworkIds;
    }

    public void prepare() {
        if (StringUtils.isEmpty((CharSequence)this.reportRegionalTopiaId)) {
            this.reportRegional = new ReportRegionalImpl();
            AuthenticatedUser authenticatedUser = this.getAuthenticatedUser();
            this.reportRegional.setAuthor(authenticatedUser.getFirstName() + " " + authenticatedUser.getLastName());
            this.networkIdsUsed = new HashSet();
        } else {
            this.authorizationService.checkReportRegionalReadable(this.reportRegionalTopiaId);
            this.reportRegional = this.reportService.getReportRegional(this.reportRegionalTopiaId);
            this.networkIdsUsed = this.reportService.getNetworkIdsUsed(this.reportRegional);
        }
    }

    protected void initForInput() {
        if (StringUtils.isNotEmpty((CharSequence)this.reportRegionalTopiaId)) {
            this.relatedReportRegionals = this.reportService.getRelatedReportRegionals(this.reportRegional.getCode());
        }
        this.groupesCibles = this.referentialService.getGroupesCibles();
    }

    @Action(value="report-regional-edit-input")
    public String input() throws Exception {
        this.initForInput();
        if (StringUtils.isNotBlank((CharSequence)this.reportRegionalTopiaId)) {
            boolean bl = this.readOnly = !this.authorizationService.isReportRegionalWritable(this.reportRegionalTopiaId);
            if (this.readOnly) {
                this.notificationSupport.reportRegionalNotWritable();
            }
        }
        return "input";
    }

    public void validate() {
        if (this.reportRegional.getCampaign() <= 1900 || this.reportRegional.getCampaign() >= 2100) {
            this.addFieldError("reportRegional.campaign", this.getText("common.filedValue.required"));
        }
        if (StringUtils.isBlank((CharSequence)this.reportRegional.getName())) {
            this.addFieldError("reportRegional.name", this.getText("common.filedValue.required"));
        }
        if (StringUtils.isBlank((CharSequence)this.reportRegional.getAuthor())) {
            this.addFieldError("reportRegional.author", this.getText("common.filedValue.required"));
        }
        if (CollectionUtils.isEmpty((Collection)this.reportRegional.getSectors())) {
            this.addFieldError("reportRegional.sectors", this.getText("common.filedValue.required"));
        } else if (this.reportRegional.getSectors().contains(Sector.ARBORICULTURE) && CollectionUtils.isEmpty((Collection)this.reportRegional.getSectorSpecies())) {
            this.addFieldError("reportRegional.sectorSpecies", this.getText("common.filedValue.required"));
        }
        if (CollectionUtils.isEmpty((Collection)this.reportRegionalNetworkIds)) {
            this.addFieldError("reportRegionalNetworkIds", this.getText("common.filedValue.required"));
        }
        if (this.hasErrors()) {
            this.initForInput();
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "report-regional-edit-input", "reportRegionalTopiaId", "${reportRegional.topiaId}"})})
    public String execute() throws Exception {
        Type collectionType = new /* Unavailable Anonymous Inner Class!! */.getType();
        List diseasePressures = (List)this.getGson().fromJson(this.diseasePressuresJson, collectionType);
        List pestPressures = (List)this.getGson().fromJson(this.pestPressuresJson, collectionType);
        this.reportRegional = this.reportService.createOrUpdateReportRegional(this.reportRegional, this.reportRegionalNetworkIds, diseasePressures, pestPressures);
        this.notificationSupport.reportRegionalSaved(this.reportRegional);
        return "success";
    }

    public void setDiseasePressuresJson(String diseasePressuresJson) {
        this.diseasePressuresJson = diseasePressuresJson;
    }

    public String getDiseasePressuresJson() {
        return this.diseasePressuresJson;
    }

    public void setPestPressuresJson(String pestPressuresJson) {
        this.pestPressuresJson = pestPressuresJson;
    }

    public String getPestPressuresJson() {
        return this.pestPressuresJson;
    }

    public LinkedHashMap<Integer, String> getRelatedReportRegionals() {
        return this.relatedReportRegionals;
    }

    public Set<String> getNetworkIdsUsed() {
        return this.networkIdsUsed;
    }

    public List<GroupeCibleDTO> getGroupesCibles() {
        return this.groupesCibles;
    }

    public BioAgressorParentType getDiseaseBioAgressorParentType() {
        return Referentials.MALADIE;
    }

    public BioAgressorParentType getPestBioAgressorParentType() {
        return Referentials.RAVAGEUR;
    }
}

