/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.reports;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.report.ReportGrowingSystemDto;
import fr.inra.agrosyst.api.services.report.ReportGrowingSystemFilter;
import fr.inra.agrosyst.api.services.report.ReportService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportGrowingSystemsListJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(ReportGrowingSystemsListJson.class);
    private static final long serialVersionUID = 8357676200729541321L;
    protected transient ReportService reportService;
    protected transient String filter;

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public String execute() {
        try {
            ReportGrowingSystemFilter rfilter = (ReportGrowingSystemFilter)this.getGson().fromJson(this.filter, ReportGrowingSystemFilter.class);
            this.writeListNbElementByPage(ReportGrowingSystemDto.class, rfilter.getPageSize());
            NavigationContext navigationContext = this.getNavigationContext();
            rfilter.setNavigationContext(navigationContext);
            this.jsonData = this.reportService.getAllReportGrowingSystem(rfilter);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load report growing system list", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }
}

