/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.reports;

import fr.inra.agrosyst.api.services.common.ExportResult;
import fr.inra.agrosyst.api.services.report.ReportService;
import fr.inra.agrosyst.web.actions.commons.AbstractExportAction;
import java.util.List;
import java.util.stream.Collectors;

public class ReportGrowingSystemExportXls
extends AbstractExportAction {
    private static final long serialVersionUID = 8686993981231582811L;
    protected transient ReportService reportService;
    protected List<String> reportGrowingSystemIds;

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setReportGrowingSystemIds(String reportGrowingSystemIds) {
        this.reportGrowingSystemIds = (List)this.getGson().fromJson(reportGrowingSystemIds, List.class);
    }

    protected ExportResult computeExportResult() {
        List safeReportGrowingSystemIds = this.reportGrowingSystemIds.stream().filter(reportGrowingSystemId -> {
            try {
                this.authorizationService.checkReportGrowingSystemReadable(reportGrowingSystemId);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }).collect(Collectors.toList());
        ExportResult result = this.reportService.exportXlsReportGrowingSystems(safeReportGrowingSystemIds);
        return result;
    }
}

