/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.referential;

import fr.inra.agrosyst.api.entities.referential.WineValorisation;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.lang.reflect.Type;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadDestinationsContextJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(LoadDestinationsContextJson.class);
    private static final long serialVersionUID = -2690053349676146644L;
    protected transient String growingSystemId;
    protected transient String campaigns;
    protected transient String zoneTopiaId;
    protected transient Set<String> speciesCodes;
    protected transient Set<WineValorisation> wineValorisations;
    protected transient ReferentialService referentialService;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public String execute() throws Exception {
        try {
            this.jsonData = this.referentialService.getDestinationContext(this.speciesCodes, this.wineValorisations, this.growingSystemId, this.campaigns, this.zoneTopiaId);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load DestinationContext for speciesCodes '%s', wineValorisations '%s', growingSystemId '%s', campaigns '%s', zoneTopiaId '%s'", this.speciesCodes, this.wineValorisations, this.growingSystemId, this.campaigns, this.zoneTopiaId), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    public void setSpeciesCodes(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.speciesCodes = (Set)this.getGson().fromJson(json, type);
    }

    public void setWineValorisations(String wineValorisations) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.wineValorisations = (Set)this.getGson().fromJson(wineValorisations, type);
    }

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

    public void setCampaigns(String campaigns) {
        this.campaigns = campaigns;
    }

    public void setZoneTopiaId(String zoneTopiaId) {
        this.zoneTopiaId = zoneTopiaId;
    }
}

