/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.practiced;

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.exceptions.AgrosystDuplicationException;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PracticedSystemsDuplicate
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(PracticedSystemsDuplicate.class);
    private static final long serialVersionUID = 3763987457979325440L;
    protected ArrayList<String> practicedSystemIds;
    protected String practicedSystemId;
    protected String growingSystemId;
    protected transient PracticedSystemService practicedSystemService;
    protected PracticedSystem practicedSystem;

    public void setGrowingSystemId(String growingSystemId) {
        this.growingSystemId = growingSystemId;
    }

    public void setPracticedSystemService(PracticedSystemService practicedSystemService) {
        this.practicedSystemService = practicedSystemService;
    }

    public void setPracticedSystemId(String practicedSystemId) {
        this.practicedSystemId = practicedSystemId;
    }

    public String execute() throws Exception {
        if (Strings.isNullOrEmpty((String)this.practicedSystemId) || Strings.isNullOrEmpty((String)this.growingSystemId)) {
            this.notificationSupport.practicedSystemNotDuplicable(this.practicedSystemId, this.growingSystemId);
            return "error";
        }
        try {
            this.practicedSystem = this.practicedSystemService.duplicatePracticedSystemWithUsages(this.practicedSystemId, this.growingSystemId);
            this.jsonData = this.practicedSystem.getTopiaId();
        }
        catch (AgrosystDuplicationException ade) {
            this.jsonData = ade.getLocalizedMessage();
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"\u00c9CHEC DE DUPLICATION DU SYST\u00c8ME SYNT\u00c9THIS\u00c9", (Throwable)ade);
            }
            return "error";
        }
        catch (Exception e) {
            this.jsonData = e.getLocalizedMessage();
            this.notificationSupport.practicedSystemNotDuplicable(e.toString());
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"\u00c9CHEC DE DUPLICATION DU SYST\u00c8ME SYNTH\u00c9TIS\u00c9", (Throwable)e);
            }
            return "error";
        }
        this.notificationSupport.practicedSystemDuplicate();
        return "success";
    }

    public PracticedSystem getPracticedSystem() {
        return this.practicedSystem;
    }

    public void setPracticedSystemIds(String practicedSystemIds) {
        this.practicedSystemIds = (ArrayList)this.getGson().fromJson(practicedSystemIds, ArrayList.class);
    }
}

