/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.practiced;

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.referential.ProductType;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadActaProductsJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(LoadActaProductsJson.class);
    private static final long serialVersionUID = 3763987457979325440L;
    protected transient ReferentialService referentialService;
    protected transient AgrosystInterventionType inputType;
    protected transient ProductType productType;

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setProductType(ProductType productType) {
        this.productType = productType;
    }

    public void setInputType(AgrosystInterventionType inputType) {
        this.inputType = inputType;
    }

    public String execute() {
        try {
            this.jsonData = this.referentialService.getActaTraitementsProduits(this.inputType, this.productType);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load Acta products for inputType '%s' and productType '%s' ", this.inputType, this.productType), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }
}

