/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.managementmodes;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeDto;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeFilter;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.pagination.PaginationResult;

public class ManagementModesList
extends AbstractAgrosystAction {
    private static final Log LOGGER = LogFactory.getLog(ManagementModesList.class);
    private static final long serialVersionUID = -5032928580196001618L;
    protected ManagementModeFilter managementModeFilter;
    protected transient ManagementModeService managementModeService;
    protected PaginationResult<ManagementModeDto> managementModeDtos;
    protected int managementModesExportAsyncThreshold;

    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    public String execute() throws Exception {
        try {
            NavigationContext navigationContext = this.getNavigationContext();
            this.managementModeFilter = new ManagementModeFilter();
            this.managementModeFilter.setNavigationContext(navigationContext);
            this.managementModeFilter.setPageSize(this.getListNbElementByPage(ManagementModeDto.class).intValue());
            this.managementModeDtos = this.managementModeService.getFilteredManagementModeDtos(this.managementModeFilter);
            this.managementModesExportAsyncThreshold = this.config.getManagementModesExportAsyncThreshold();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load management modes", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    public ManagementModeFilter getManagementModeFilter() {
        return this.managementModeFilter;
    }

    public PaginationResult<ManagementModeDto> getManagementModeDtos() {
        return this.managementModeDtos;
    }

    public int getManagementModesExportAsyncThreshold() {
        return this.managementModesExportAsyncThreshold;
    }
}

