/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.managementmodes;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.services.managementmode.DecisionRuleFilter;
import fr.inra.agrosyst.api.services.managementmode.DecisionRulesDto;
import fr.inra.agrosyst.api.services.managementmode.ManagementModeService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.util.Map;
import lombok.Generated;
import org.nuiton.util.pagination.PaginationResult;

public class DecisionRulesList
extends AbstractAgrosystAction {
    private static final long serialVersionUID = -8916181887544412258L;
    protected transient ManagementModeService managementModeService;
    protected transient ReferentialService referentialService;
    protected PaginationResult<DecisionRulesDto> decisionRules;
    protected DecisionRuleFilter decisionRuleFilter;
    protected int decisionRulesExportAsyncThreshold;

    public String execute() throws Exception {
        NavigationContext navigationContext = this.getNavigationContext();
        this.decisionRuleFilter = new DecisionRuleFilter();
        this.decisionRuleFilter.setNavigationContext(navigationContext);
        this.decisionRuleFilter.setPageSize(this.getListNbElementByPage(DecisionRulesDto.class).intValue());
        this.decisionRuleFilter.setActive(Boolean.TRUE);
        this.decisionRules = this.managementModeService.getFilteredDecisionRules(this.decisionRuleFilter);
        this.decisionRulesExportAsyncThreshold = this.config.getDecisionRulesExportAsyncThreshold();
        return "success";
    }

    public Map<AgrosystInterventionType, String> getAgrosystInterventionTypes() {
        return this.referentialService.getAgrosystInterventionTypeTranslationMap();
    }

    @Generated
    public ManagementModeService getManagementModeService() {
        return this.managementModeService;
    }

    @Generated
    public ReferentialService getReferentialService() {
        return this.referentialService;
    }

    @Generated
    public PaginationResult<DecisionRulesDto> getDecisionRules() {
        return this.decisionRules;
    }

    @Generated
    public DecisionRuleFilter getDecisionRuleFilter() {
        return this.decisionRuleFilter;
    }

    @Generated
    public int getDecisionRulesExportAsyncThreshold() {
        return this.decisionRulesExportAsyncThreshold;
    }

    @Generated
    public void setManagementModeService(ManagementModeService managementModeService) {
        this.managementModeService = managementModeService;
    }

    @Generated
    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    @Generated
    public void setDecisionRules(PaginationResult<DecisionRulesDto> decisionRules) {
        this.decisionRules = decisionRules;
    }

    @Generated
    public void setDecisionRuleFilter(DecisionRuleFilter decisionRuleFilter) {
        this.decisionRuleFilter = decisionRuleFilter;
    }

    @Generated
    public void setDecisionRulesExportAsyncThreshold(int decisionRulesExportAsyncThreshold) {
        this.decisionRulesExportAsyncThreshold = decisionRulesExportAsyncThreshold;
    }
}

