/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.generic;

import fr.inra.agrosyst.api.entities.security.HashedValue;
import fr.inra.agrosyst.api.services.generic.GenericFilter;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.Preparable;
import org.nuiton.util.pagination.PaginationResult;

public class GenericEntitiesList
extends AbstractAdminAction
implements Preparable {
    private static final Log LOGGER = LogFactory.getLog(GenericEntitiesList.class);
    private static final long serialVersionUID = -2256628821672426679L;
    protected String genericClassName;
    protected List<String> properties;
    protected String entitiesJson;
    protected boolean importFileError;

    public void setImportFileError(boolean importFileError) {
        this.importFileError = importFileError;
    }

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public void prepare() throws Exception {
        super.prepare();
        if (this.importFileError) {
            this.notificationSupport.error("\u00c9CHEC : %s", new Object[]{"format de fichier incorrect"});
            this.importFileError = false;
        }
        try {
            Class<?> klass = Class.forName(this.genericClassName);
            this.properties = this.service.getPropertiesFromString(this.genericClassName);
            GenericFilter filter = new GenericFilter();
            filter.setPageSize(this.getListNbElementByPage(klass).intValue());
            PaginationResult entities = this.service.listEntities(klass, filter);
            if (klass.isEnum()) {
                this.properties.add("Traduction");
                for (Object entity : entities.getElements()) {
                    Map entityMap = (Map)entity;
                    String name = (String)entityMap.get("Valeur");
                    String traduction = this.getText(klass.getName() + "." + name);
                    entityMap.put("Traduction", traduction);
                }
            }
            this.entitiesJson = this.getGson().toJson((Object)entities);
        }
        catch (ClassNotFoundException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Un exception occured", (Throwable)e);
            }
            this.properties = new ArrayList();
        }
    }

    public String execute() throws Exception {
        this.checkIsAdmin();
        return "success";
    }

    public String getGenericClassName() {
        return this.genericClassName;
    }

    public String getEntitiesJson() {
        return this.entitiesJson;
    }

    public List<String> getProperties() {
        ArrayList<String> copy = new ArrayList<String>();
        if (this.properties != null) {
            copy.addAll(this.properties);
            copy.remove("active");
            copy.remove("refCountry");
        }
        return copy;
    }

    public int getPropertiesSize() {
        int result = 0;
        if (this.properties != null) {
            result = this.properties.size();
        }
        return ++result;
    }

    public boolean isReferential() {
        boolean result = this.genericClassName.startsWith("fr.inra.agrosyst.api.entities.referential.Ref") || this.genericClassName.startsWith("fr.inra.agrosyst.api.entities.referential.TradRef") || this.genericClassName.startsWith("fr.inra.agrosyst.api.entities.referential.refApi.Ref") || this.genericClassName.startsWith("fr.inra.agrosyst.services.referential.csv.RefEspeceDto") || this.genericClassName.startsWith("fr.inra.agrosyst.services.referential.csv.RefLocationExtendedDto");
        return result;
    }

    public boolean isTranslation() {
        return this.genericClassName.startsWith("fr.inra.agrosyst.api.entities.referential.TradRef");
    }

    public boolean isHashedValues() {
        boolean result = HashedValue.class.getName().equals(this.genericClassName);
        return result;
    }

    public boolean isReferentialOrHashedValues() {
        return this.isReferential() || this.isHashedValues();
    }

    public boolean isRefCountry() {
        return this.properties.contains("refCountry");
    }
}

