/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.effective;

import fr.inra.agrosyst.api.entities.CroppingPlanEntry;
import fr.inra.agrosyst.api.entities.VariableType;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.measure.ChemicalElement;
import fr.inra.agrosyst.api.entities.measure.HorizonType;
import fr.inra.agrosyst.api.entities.measure.MeasureType;
import fr.inra.agrosyst.api.entities.measure.Measurement;
import fr.inra.agrosyst.api.entities.measure.MeasurementSession;
import fr.inra.agrosyst.api.entities.measure.MeasurementType;
import fr.inra.agrosyst.api.entities.measure.NitrogenMolecule;
import fr.inra.agrosyst.api.entities.measure.ProductivityType;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActive;
import fr.inra.agrosyst.api.entities.referential.RefAdventice;
import fr.inra.agrosyst.api.entities.referential.RefSupportOrganeEDI;
import fr.inra.agrosyst.api.services.measurement.MeasurementService;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class EffectiveMeasurementsEdit
extends AbstractAgrosystAction
implements Preparable {
    private static final Log LOGGER = LogFactory.getLog(EffectiveMeasurementsEdit.class);
    private static final long serialVersionUID = 6018591779575353579L;
    protected transient MeasurementService measurementService;
    protected transient PlotService plotService;
    protected String zoneTopiaId;
    protected Zone zone;
    protected Set<CroppingPlanEntry> croppingPlanEntries;
    protected List<MeasurementSession> measurementSessions;
    protected List<RefSupportOrganeEDI> supportOrganeEdis;
    protected List<RefActaSubstanceActive> substanceActives;
    protected List<RefAdventice> adventices;
    protected LinkedHashMap<Integer, String> relatedZones;

    public void setMeasurementService(MeasurementService measurementService) {
        this.measurementService = measurementService;
    }

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public String getZoneTopiaId() {
        return this.zoneTopiaId;
    }

    public void setZoneTopiaId(String zoneTopiaId) {
        this.zoneTopiaId = zoneTopiaId;
    }

    public Zone getZone() {
        return this.zone;
    }

    public void prepare() {
        this.zone = this.measurementService.getZone(this.zoneTopiaId);
        this.activated = this.zone.isActive() && this.zone.getPlot().isActive() && this.zone.getPlot().getDomain().isActive() && (this.zone.getPlot().getGrowingSystem() == null || this.zone.getPlot().getGrowingSystem().isActive());
    }

    @Action(value="effective-measurements-edit-input")
    public String input() throws Exception {
        this.initForInput();
        this.measurementSessions = this.measurementService.getZoneMeasurementSessions(this.zone);
        return "input";
    }

    protected void initForInput() {
        this.croppingPlanEntries = this.measurementService.getZoneCroppingPlanEntries(this.zone);
        this.supportOrganeEdis = this.measurementService.findAllSupportOrganeEDI();
        this.substanceActives = this.measurementService.findDistinctSubstanceActives();
        this.adventices = this.measurementService.findAllAdventices();
        this.relatedZones = this.plotService.getRelatedZones(this.zone.getCode());
    }

    public Map<MeasurementType, String> getMeasurementMeasureTypes() {
        return this.getEnumAsMap((Object[])new MeasurementType[]{MeasurementType.PLANTE, MeasurementType.SOL, MeasurementType.TRANSFERT_DE_SOLUTES, MeasurementType.GES, MeasurementType.METEO});
    }

    public Map<MeasurementType, String> getMeasurementObservationTypes() {
        return this.getEnumAsMap((Object[])new MeasurementType[]{MeasurementType.STADE_CULTURE, MeasurementType.NUISIBLE_MALADIES_PHYSIOLOGIQUES_AUXILIAIRES, MeasurementType.ADVENTICES});
    }

    public Map<VariableType, String> getVariableTypes() {
        return this.getEnumAsMap((Object[])VariableType.values());
    }

    public Map<MeasureType, String> getMeasureTypes() {
        return this.getEnumAsMap((Object[])MeasureType.values());
    }

    public Map<ProductivityType, String> getProductivityTypes() {
        return this.getEnumAsMap((Object[])ProductivityType.values());
    }

    public Map<ChemicalElement, String> getChemicalElements() {
        return this.getEnumAsMap((Object[])ChemicalElement.values());
    }

    public Map<HorizonType, String> getHorizonTypes() {
        return this.getEnumAsMap((Object[])HorizonType.values());
    }

    public Map<NitrogenMolecule, String> getNitrogenMolecules() {
        return this.getEnumAsMap((Object[])NitrogenMolecule.values());
    }

    public void validate() {
        if (this.measurementSessions != null) {
            for (MeasurementSession measurementSession : this.measurementSessions) {
                Collection measurements;
                if (measurementSession.getStartDate() == null) {
                    this.addActionError("Une serie de mesures doit avoir une date de d\u00e9but !");
                }
                if ((measurements = measurementSession.getMeasurements()) == null) continue;
                for (Measurement measurement : measurements) {
                    if (measurement == null || measurement.getMeasurementType() != null) continue;
                    this.addActionError("Une mesure ou observation doit avoir un type !");
                }
            }
            if (!this.activated) {
                this.addActionError("La zone et/ou sa parcelle et/ou son system de culture et/ou son dispositif et/ou son domain sont inactifs !");
            }
        }
        if (this.hasErrors()) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, action errors : Mesures et observations de la zone:'%s' -> %s", this.zoneTopiaId, this.getActionErrors().toString()));
                LOGGER.error((Object)String.format("For user email:" + this.getAuthenticatedUser().getEmail() + ":validate, fields errors : Mesures et observations de la zone:'%s' -> %s", this.zoneTopiaId, this.getFieldErrors().toString()));
            }
            this.initForInput();
        }
    }

    @Action(results={@Result(name={"success"}, type="redirectAction", params={"actionName", "effective-measurements-edit-input", "zoneTopiaId", "${zoneTopiaId}"})})
    public String execute() throws Exception {
        this.measurementService.updateMeasurementSessions(this.zone, (Collection)this.measurementSessions);
        return "success";
    }

    public List<MeasurementSession> getMeasurementSessions() {
        return this.measurementSessions;
    }

    public void setMeasurementSessions(String json) {
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.measurementSessions = (List)this.getGson().fromJson(json, type);
    }

    public Set<CroppingPlanEntry> getCroppingPlanEntries() {
        return this.croppingPlanEntries;
    }

    public List<RefSupportOrganeEDI> getSupportOrganeEdis() {
        return this.supportOrganeEdis;
    }

    public List<RefActaSubstanceActive> getSubstanceActives() {
        return this.substanceActives;
    }

    public List<RefAdventice> getAdventices() {
        return this.adventices;
    }

    public LinkedHashMap<Integer, String> getRelatedZones() {
        return this.relatedZones;
    }
}

