/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.domains;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DomainsListJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(DomainsListJson.class);
    private static final long serialVersionUID = 8462808027355013164L;
    protected transient DomainService domainService;
    protected transient boolean fromNavigationContextChoose = false;
    protected transient String filter;
    protected transient Set<Integer> selectedCampaigns = new HashSet();
    protected transient Set<String> selectedNetworks = new HashSet();
    protected transient Boolean pagination = true;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setFromNavigationContextChoose(boolean fromNavigationContextChoose) {
        this.fromNavigationContextChoose = fromNavigationContextChoose;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setSelectedCampaigns(Set<Integer> selectedCampaigns) {
        this.selectedCampaigns = selectedCampaigns;
    }

    public void setSelectedNetworks(Set<String> selectedNetworks) {
        this.selectedNetworks = selectedNetworks;
    }

    public void setPagination(Boolean pagination) {
        this.pagination = pagination;
    }

    public String execute() {
        try {
            NavigationContext navigationContext;
            DomainFilter domainFilter = (DomainFilter)this.getGson().fromJson(this.filter, DomainFilter.class);
            if (this.fromNavigationContextChoose) {
                navigationContext = new NavigationContext(this.selectedCampaigns, this.selectedNetworks, null, null, null);
                this.writeListNbElementByPage(DomainDto.class, "NavigationContext", domainFilter.getPageSize());
            } else {
                navigationContext = this.getNavigationContext();
                if (!this.pagination.booleanValue()) {
                    domainFilter.setAllPageSize();
                    domainFilter.setPage(0);
                } else {
                    this.writeListNbElementByPage(DomainDto.class, domainFilter.getPageSize());
                }
            }
            domainFilter.setNavigationContext(navigationContext);
            this.jsonData = this.domainService.getFilteredDomainsDto(domainFilter);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load domains list", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }
}

