/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.domains;

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.domain.DomainFilter;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.util.Map;
import org.nuiton.util.pagination.PaginationResult;

public class DomainsList
extends AbstractAgrosystAction {
    private static final long serialVersionUID = -5828110601098674893L;
    protected DomainFilter domainFilter;
    protected transient DomainService domainService;
    protected PaginationResult<DomainDto> domains;
    protected boolean importFileError;
    protected int exportAsyncThreshold;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setImportFileError(boolean importFileError) {
        this.importFileError = importFileError;
    }

    public String execute() throws Exception {
        if (this.importFileError) {
            this.notificationSupport.importError("Format de fichier incorrect !");
            this.importFileError = false;
        }
        this.domainFilter = new DomainFilter();
        NavigationContext navigationContext = this.getNavigationContext();
        this.domainFilter.setNavigationContext(navigationContext);
        this.domainFilter.setPageSize(this.getListNbElementByPage(DomainDto.class).intValue());
        this.domainFilter.setActive(Boolean.TRUE);
        this.domains = this.domainService.getFilteredDomainsDto(this.domainFilter);
        this.exportAsyncThreshold = this.config.getDomainsExportAsyncThreshold();
        return "success";
    }

    public Map<DomainType, String> getTypes() {
        return this.i18nService.getEnumTranslationMap(DomainType.class);
    }

    public DomainFilter getDomainFilter() {
        return this.domainFilter;
    }

    public PaginationResult<DomainDto> getDomains() {
        return this.domains;
    }

    public int getExportAsyncThreshold() {
        return this.exportAsyncThreshold;
    }
}

