/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.domains;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.MaterielType;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.referential.RefAnimalType;
import fr.inra.agrosyst.api.entities.referential.RefCattleAnimalType;
import fr.inra.agrosyst.api.entities.referential.RefCattleRationAliment;
import fr.inra.agrosyst.api.services.common.InputPriceFilter;
import fr.inra.agrosyst.api.services.common.InputPriceService;
import fr.inra.agrosyst.api.services.common.UsageList;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.domain.inputStock.DomainInputStockUnitService;
import fr.inra.agrosyst.api.services.domain.inputStock.search.PhytoProductInputFilter;
import fr.inra.agrosyst.api.services.plot.PlotService;
import fr.inra.agrosyst.api.services.referential.RefSubstrateDto;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.api.services.referential.TypeMaterielFilter;
import fr.inra.agrosyst.services.common.EntityUsageService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.SetValuedMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.Preparable;
import org.apache.struts2.convention.annotation.Action;

public class DomainsEditJson
extends AbstractJsonAction
implements Preparable {
    private static final Log LOGGER = LogFactory.getLog(DomainsEditJson.class);
    private static final long serialVersionUID = -4134613183262825235L;
    protected transient DomainInputStockUnitService domainInputStockUnitService;
    protected transient DomainService domainService;
    protected transient EntityUsageService entityUsageService;
    protected transient InputPriceService inputPriceService;
    protected transient PlotService plotService;
    protected transient ReferentialService referentialService;
    protected transient String filter;
    protected transient Integer regionCode;
    protected transient Integer otex18code;
    protected transient String domainName;
    protected transient String domainId;
    protected transient String toolsCouplingCode;
    protected transient String materielId;

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setEntityUsageService(EntityUsageService entityUsageService) {
        this.entityUsageService = entityUsageService;
    }

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setInputPriceService(InputPriceService inputPriceService) {
        this.inputPriceService = inputPriceService;
    }

    public void setDomainInputStockUnitService(DomainInputStockUnitService domainInputStockUnitService) {
        this.domainInputStockUnitService = domainInputStockUnitService;
    }

    public void prepare() {
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setRegionCode(Integer regionCode) {
        this.regionCode = regionCode;
    }

    public void setOtex18code(Integer otex18code) {
        this.otex18code = otex18code;
    }

    public void setOtex18code(String otex18code) {
        this.otex18code = StringUtils.isBlank((CharSequence)otex18code) ? null : Integer.valueOf(otex18code);
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setDomainId(String domainId) {
        if (domainId != null && !domainId.equals("undefined") && !domainId.equals("null")) {
            this.domainId = domainId;
        }
    }

    @Action(value="domain-edit-crops-context-json")
    public String getCropContext() {
        HashMap croppingPlanSpeciesUsageMap;
        HashMap croppingPlansUsageMap;
        ArrayList croppingPlans;
        HashMap<String, Cloneable> cropContext = new HashMap<String, Cloneable>();
        if (StringUtils.isNotBlank((CharSequence)this.domainId)) {
            UsageList croppingPlansUsageList = this.domainService.getCroppingPlanEntryDtoAndUsage(this.domainId);
            croppingPlans = new ArrayList(croppingPlansUsageList.getElements());
            croppingPlansUsageMap = new HashMap(croppingPlansUsageList.getUsageMap());
            croppingPlanSpeciesUsageMap = new HashMap(this.domainService.getCroppingPlanSpeciesUsage(this.domainId));
        } else {
            croppingPlans = new ArrayList();
            croppingPlansUsageMap = new HashMap();
            croppingPlanSpeciesUsageMap = new HashMap();
        }
        cropContext.put("croppingPlans", croppingPlans);
        cropContext.put("croppingPlansUsageMap", croppingPlansUsageMap);
        cropContext.put("croppingPlanSpeciesUsageMap", croppingPlanSpeciesUsageMap);
        this.jsonData = cropContext;
        return "success";
    }

    @Action(value="load-seeding-species-and-products-usages-json")
    public String getSeedingSpeciesAndProductsUsages() {
        if (this.filter != null) {
            String lotId = (String)this.getGson().fromJson(this.filter, String.class);
            Optional optionalDomainSeedLotInput = this.domainInputStockUnitService.getLotForId(lotId);
            optionalDomainSeedLotInput.ifPresent(domainSeedLotInput -> {
                this.jsonData = this.entityUsageService.getSeedingSpeciesAndProductsUsages(domainSeedLotInput.getDomainSeedSpeciesInput());
            });
        }
        this.jsonData = ObjectUtils.firstNonNull((Object[])new Object[]{this.jsonData, new HashSet()});
        return "success";
    }

    @Action(value="load-seeding-species-units-json")
    public String getSeedingSpeciesUnits() {
        List speciesIds = null;
        if (this.filter != null) {
            speciesIds = (List)this.getGson().fromJson(this.filter, List.class);
        }
        this.jsonData = this.domainInputStockUnitService.getSeedPlanUnits(speciesIds);
        return "success";
    }

    @Action(value="domain-edit-input-stock-context-json")
    public String getDomainInputStockContext() {
        try {
            HashMap<String, Map> inputsUsages = new HashMap<String, Map>();
            if (StringUtils.isNotBlank((CharSequence)this.domainId)) {
                Map domainInputDtosAndUsages = this.domainService.getDomainInputDtoUsageByTypes(this.domainId);
                inputsUsages.put("domainInputsAndUsages", domainInputDtosAndUsages);
                this.jsonData = inputsUsages;
            } else {
                inputsUsages.put("domainInputsAndUsages", new HashMap());
                this.jsonData = inputsUsages;
            }
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load domain Inputs", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="domain-edit-equipment-context-json")
    public String getEquipmentContext() {
        try {
            HashMap toolsCouplingsUsage;
            ArrayList toolsCouplings;
            ArrayList equipments;
            if (StringUtils.isNotBlank((CharSequence)this.domainId)) {
                equipments = new ArrayList(this.domainService.getEquipments(this.domainId));
                UsageList toolsCouplingsUsageList = this.domainService.getToolsCouplingAndUsage(this.domainId);
                toolsCouplings = new ArrayList(toolsCouplingsUsageList.getElements());
                toolsCouplingsUsage = new HashMap(toolsCouplingsUsageList.getUsageMap());
                if (this.domainService.isDefaultEdaplosEquipmentForDomain(equipments)) {
                    this.notificationSupport.defaultMaterialUsed();
                }
            } else {
                equipments = new ArrayList();
                toolsCouplings = new ArrayList();
                toolsCouplingsUsage = new HashMap();
            }
            boolean filterEdaplos = false;
            if (this.filter != null) {
                TypeMaterielFilter typeMaterielFilter = (TypeMaterielFilter)this.getGson().fromJson(this.filter, TypeMaterielFilter.class);
                filterEdaplos = typeMaterielFilter.isFilterEdaplos();
            }
            HashMap<String, Object> equipmentContext = new HashMap<String, Object>();
            equipmentContext.put("ManualTools", this.referentialService.getPetitMaterielTypeMateriel1List());
            equipmentContext.put(MaterielType.class.getSimpleName(), this.referentialService.getWithoutPetitMaterielTypeMateriel1List(filterEdaplos));
            equipmentContext.put(Equipment.class.getSimpleName(), equipments);
            equipmentContext.put(ToolsCoupling.class.getSimpleName(), toolsCouplings);
            equipmentContext.put(UsageList.class.getSimpleName(), toolsCouplingsUsage);
            this.jsonData = equipmentContext;
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load materiel-type2", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="domain-edit-materiel-type2-json")
    public String listMaterielType2() {
        try {
            TypeMaterielFilter typeMaterielFilter = (TypeMaterielFilter)this.getGson().fromJson(this.filter, TypeMaterielFilter.class);
            this.jsonData = this.referentialService.getTypeMateriel2List(typeMaterielFilter);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load materiel-type2", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="domain-edit-materiel-type3-json")
    public String listMaterielType3() {
        try {
            TypeMaterielFilter typeMaterielFilter = (TypeMaterielFilter)this.getGson().fromJson(this.filter, TypeMaterielFilter.class);
            this.jsonData = this.referentialService.getTypeMateriel3List(typeMaterielFilter);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load materiel-type3", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="domain-edit-materiel-type4-json")
    public String listMaterielType4() {
        try {
            TypeMaterielFilter typeMaterielFilter = (TypeMaterielFilter)this.getGson().fromJson(this.filter, TypeMaterielFilter.class);
            this.jsonData = this.referentialService.getTypeMateriel4List(typeMaterielFilter);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load materiel-type4", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="domain-edit-materiel-unite-json")
    public String listMaterielUnite() {
        try {
            TypeMaterielFilter typeMaterielFilter = (TypeMaterielFilter)this.getGson().fromJson(this.filter, TypeMaterielFilter.class);
            this.jsonData = this.referentialService.getMaterielUniteMap(typeMaterielFilter);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load MaterielUnite", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="domain-edit-materiel-all-json")
    public String listMaterielAll() {
        try {
            TypeMaterielFilter typeMaterielFilter = (TypeMaterielFilter)this.getGson().fromJson(this.filter, TypeMaterielFilter.class);
            this.jsonData = new ArrayList(4);
            ((Collection)this.jsonData).add(this.referentialService.getTypeMateriel2List(typeMaterielFilter));
            ((Collection)this.jsonData).add(this.referentialService.getTypeMateriel3List(typeMaterielFilter));
            ((Collection)this.jsonData).add(this.referentialService.getTypeMateriel4List(typeMaterielFilter));
            ((Collection)this.jsonData).add(this.referentialService.getMaterielUniteMap(typeMaterielFilter));
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load domain-edit-materiel-all", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="domain-edit-materiel-find-materiel")
    public String getMateriel() {
        try {
            this.jsonData = this.referentialService.getMateriel(this.materielId);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load materiel for materielId '%s'", this.materielId), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="domain-edit-load-plots")
    public String loadPlots() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.domainId)) {
                Domain d = this.domainService.getDomain(this.domainId);
                this.jsonData = this.plotService.findAllForDomain(d);
            } else {
                this.jsonData = new ArrayList();
            }
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load plots for domain with id '%s'", StringUtils.isNotBlank((CharSequence)this.domainId) ? this.domainId : "Cr\u00e9ation"), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="domain-edit-sol-arvalis-list-json")
    public String listSolArvalis() {
        try {
            this.jsonData = this.referentialService.getSolArvalis(this.regionCode);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load sol arvalis", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="get-ref-otex-json")
    public String listRefOtex70() {
        try {
            this.jsonData = this.referentialService.getAllActiveCodeOtex70ByOtex18code(this.otex18code);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load otex 70 for otex18code '%s'", this.otex18code), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="check-domain-name-json")
    public String checkDomainName() {
        try {
            this.jsonData = this.domainService.checkDomainExistence(this.domainName);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)("Failed to check valid domain name for name: " + this.domainName), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="load-all-active-agrosyst-actions-json")
    public String loadAllActiveAgrosystActions() {
        try {
            this.jsonData = this.referentialService.getAllActiveAgrosystActions();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load ref agrosyst action", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="load-livestock-units-actions-json")
    public String loadLivestockUnitsActions() {
        try {
            HashMap<String, Object> res0 = new HashMap<String, Object>();
            res0.put("LivestocksAndCattles", StringUtils.isNotBlank((CharSequence)this.domainId) ? this.domainService.getUsedLivestocksAndCattles(this.domainId) : new HashMap());
            List refAnimalTypes = this.referentialService.getAllTranslatedActiveRefAnimalTypes();
            List refCattleAnimalTypes = this.referentialService.getAllTranslatedActiveRefCattleAnimalTypes();
            List refCattleRationAliments = this.referentialService.getAllTranslatedActiveRefCattleRationAliments();
            res0.put(RefAnimalType.class.getName(), refAnimalTypes);
            res0.put(RefCattleAnimalType.class.getName(), refCattleAnimalTypes);
            res0.put(RefCattleRationAliment.class.getName(), refCattleRationAliments);
            this.jsonData = res0;
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load ref agrosyst action", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    public void setToolsCouplingCode(String toolsCouplingCode) {
        this.toolsCouplingCode = toolsCouplingCode;
    }

    public void setMaterielId(String materielId) {
        this.materielId = materielId;
    }

    @Action(value="load-phyto-products-json")
    public String loadPhytoProducts() {
        try {
            PhytoProductInputFilter phytoProductInputFilter = (PhytoProductInputFilter)this.getGson().fromJson(this.filter, PhytoProductInputFilter.class);
            phytoProductInputFilter = phytoProductInputFilter.toBuilder().isWithAmmCode(Boolean.valueOf(true)).build();
            this.jsonData = this.referentialService.getDomainPhytoProductInputSearchResults(phytoProductInputFilter);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load phyto products", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="load-biological-control-inputs")
    public String loadBiologicalControlInputs() {
        try {
            PhytoProductInputFilter phytoProductInputFilter = (PhytoProductInputFilter)this.getGson().fromJson(this.filter, PhytoProductInputFilter.class);
            this.jsonData = this.referentialService.getDomainBiologicalControlInputsSearchResults(phytoProductInputFilter);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load phyto products", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="load-input-ref-prices-json")
    public String loadInputRefPrices() {
        try {
            InputPriceFilter inputPriceFilter = (InputPriceFilter)this.getGson().fromJson(this.filter, InputPriceFilter.class);
            this.jsonData = this.inputPriceService.loadPriceIndications(inputPriceFilter, this.domainId);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load input ref prices", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="load-ref-pots-json")
    public String loadRefPots() {
        try {
            this.jsonData = this.referentialService.getAllActiveRefPots();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load ref pots", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="load-ref-substrates-json")
    public String loadRefSubstrates() {
        try {
            SetValuedMap substratesByCharacteristic1 = MultiMapUtils.newSetValuedHashMap();
            List allActiveRefSubstrates = this.referentialService.getAllActiveRefSubstrates();
            for (RefSubstrateDto substrate : allActiveRefSubstrates) {
                substratesByCharacteristic1.put((Object)substrate.getCharacteristic1Translated(), (Object)substrate);
            }
            this.jsonData = substratesByCharacteristic1.asMap();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load ref substrates", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    @Action(value="load-ref-other-inputs-json")
    public String loadRefOtherInputs() {
        try {
            this.jsonData = this.referentialService.getAllActiveRefOtherInputs();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load ref pots", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }
}

