/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.commons;

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.entities.referential.RefDepartmentShape;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;

public class ShowLocationRaw
extends AbstractAgrosystAction {
    private static final long serialVersionUID = -3545222983056002193L;
    protected transient ReferentialService referentialService;
    protected Double latitude;
    protected Double longitude;
    protected String locationId;
    protected String name;
    protected String departmentCode;
    protected Double centerLatitude;
    protected Double centerLongitude;
    protected String provider;
    protected RefLocation location;
    protected RefDepartmentShape departmentShape;
    protected String departmentName = "n/c";

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public String execute() throws Exception {
        this.provider = "Esri.WorldImagery";
        if (!Strings.isNullOrEmpty((String)this.locationId)) {
            this.location = this.referentialService.getRefLocation(this.locationId);
            this.departmentCode = this.location.getDepartement();
        }
        if ((this.latitude == null || Math.abs(this.latitude + 8888.8) < 1.0E-4) && (this.longitude == null || Math.abs(this.longitude + 8888.8) < 1.0E-4)) {
            this.location = null;
            this.latitude = null;
            this.longitude = null;
        } else {
            this.centerLatitude = this.latitude;
            this.centerLongitude = this.longitude;
        }
        if (!Strings.isNullOrEmpty((String)this.departmentCode)) {
            this.departmentShape = this.referentialService.getDepartmentShape(this.departmentCode);
            if (this.departmentShape != null) {
                this.departmentName = this.getText("departement." + this.departmentShape.getDepartment());
                if (this.latitude == null && this.longitude == null) {
                    this.centerLatitude = this.departmentShape.getLatitude();
                    this.centerLongitude = this.departmentShape.getLongitude();
                }
            }
        }
        return "success";
    }

    public Double getCenterLatitude() {
        return this.centerLatitude;
    }

    public Double getCenterLongitude() {
        return this.centerLongitude;
    }

    public String getLatitude() {
        return String.format("%.5f", this.latitude).replaceAll(",", ".");
    }

    public String getLongitude() {
        return String.format("%.5f", this.longitude).replaceAll(",", ".");
    }

    public String getName() {
        return Strings.emptyToNull((String)this.name);
    }

    public String getProvider() {
        return this.provider;
    }

    public RefLocation getLocation() {
        return this.location;
    }

    public RefDepartmentShape getDepartmentShape() {
        return this.departmentShape;
    }

    public String getDepartmentName() {
        return this.departmentName;
    }
}

