/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.commons;

import fr.inra.agrosyst.api.services.common.LoadedPricesResult;
import fr.inra.agrosyst.api.services.common.PricesService;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoadPricesJson
extends AbstractJsonAction {
    private static final Log LOGGER = LogFactory.getLog(LoadPricesJson.class);
    private static final long serialVersionUID = -1437968191353986009L;
    private transient PricesService pricesService;
    private transient String domainId;

    public void setPricesService(PricesService pricesService) {
        this.pricesService = pricesService;
    }

    public String execute() throws Exception {
        try {
            LoadedPricesResult pResult = this.pricesService.getHarvestingPriceResults(this.domainId);
            this.jsonData = pResult.getHarvestingValorisationPrices();
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)String.format("Failed to load prices for domainId '%s'", this.domainId), (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }
}

