/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.commons;

import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.services.common.AgrosystI18nService;
import fr.inra.agrosyst.web.actions.AbstractAgrosystAction;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.struts2.Preparable;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class I18nAction
extends AbstractAgrosystAction
implements Preparable {
    private static final long serialVersionUID = 2931731809232596488L;
    private final SortedMap<String, Map<String, String>> i18n = new TreeMap();
    private String userLocale;
    private String defaultLocale;

    public void prepare() {
        this.userLocale = this.i18nService.getLocale().toString();
        this.defaultLocale = AgrosystI18nService.getDefaultLocale().toString();
    }

    public String execute() {
        Reflections reflections = new Reflections("fr.inra.agrosyst.api", new Scanner[0]);
        Set enumClasses = reflections.getSubTypesOf(Enum.class);
        enumClasses.forEach(aEnum -> {
            LinkedHashMap translate = new LinkedHashMap();
            if (this.i18nService.isTranslatedInDatabase(aEnum)) {
                Map enumTranslationMap = this.i18nService.getEnumTranslationMap(aEnum);
                enumTranslationMap.forEach((key, value) -> translate.put(key.name(), value));
            } else {
                Map enumAsMap = this.i18nService.getEnumAsMap(null, (Object[])((Enum[])aEnum.getEnumConstants()));
                enumAsMap.forEach((key, value) -> translate.put(key.name(), value));
            }
            this.i18n.put(aEnum.getSimpleName(), translate);
        });
        Method[] declaredMethods = AgrosystI18nService.class.getDeclaredMethods();
        Arrays.stream(declaredMethods).filter(m -> m.getAnnotation(AgrosystI18nService.EnumContext.class) != null).forEach(m -> {
            AgrosystI18nService.EnumContext annotation = m.getAnnotation(AgrosystI18nService.EnumContext.class);
            Class aEnum = annotation.contextEnum();
            String context = annotation.context();
            try {
                Map enumAsMap = (Map)m.invoke((Object)this.i18nService, new Object[0]);
                LinkedHashMap translate = new LinkedHashMap();
                enumAsMap.forEach((key, value) -> translate.put(key.name(), value));
                this.i18n.put(aEnum.getSimpleName() + "#" + context, translate);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new AgrosystTechnicalException("Can't translate enum", (Throwable)ex);
            }
        });
        this.i18n.put("messages", this.i18nService.getMessages());
        return "success";
    }

    public SortedMap<String, Map<String, String>> getI18n() {
        return this.i18n;
    }

    public String getUserLocale() {
        return this.userLocale;
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }
}

