/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.commons;

import fr.inra.agrosyst.api.entities.AttachmentMetadata;
import fr.inra.agrosyst.api.services.security.AgrosystAccessDeniedException;
import fr.inra.agrosyst.web.actions.AbstractJsonAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.action.UploadedFilesAware;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class AttachmentsUploadJson
extends AbstractJsonAction
implements UploadedFilesAware {
    private static final Log LOGGER = LogFactory.getLog(AttachmentsUploadJson.class);
    protected transient String objectReferenceId;
    protected transient List<File> files;
    protected transient List<String> filesContentType;
    protected transient List<String> filesFileName;

    public String execute() throws Exception {
        try {
            ArrayList<AttachmentMetadata> attachmentMetadatas = new ArrayList<AttachmentMetadata>();
            for (int i = 0; i < CollectionUtils.emptyIfNull((Collection)this.files).size(); ++i) {
                File file = (File)this.files.get(i);
                String fileFileName = (String)this.filesFileName.get(i);
                String fileContentType = (String)this.filesContentType.get(i);
                AttachmentMetadata attachmentMetadata = this.attachmentService.addAttachment(this.objectReferenceId, (InputStream)new FileInputStream(file), fileFileName, fileContentType);
                attachmentMetadatas.add(attachmentMetadata);
            }
            this.jsonData = attachmentMetadatas;
        }
        catch (AgrosystAccessDeniedException e) {
            this.jsonData = "Vous n'avez pas les autorisations n\u00e9cessaires pour effectuer cette action.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load attachment metadata", (Throwable)e);
            }
            return "error";
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)"Failed to load attachment metadata", (Throwable)e);
            }
            return "error";
        }
        return "success";
    }

    public void withUploadedFiles(List<UploadedFile> uploadedFiles) {
        if (LOGGER.isDebugEnabled()) {
            Collection uploadedFiles1 = CollectionUtils.emptyIfNull(uploadedFiles);
            LOGGER.debug((Object)String.format("L'utilisateur %s \u00e0 envoy\u00e9 les pi\u00e8ces jointes suivante %s", this.getAuthenticatedUser().getEmail(), uploadedFiles1.stream().map(UploadedFile::getOriginalName).collect(Collectors.joining())));
        }
    }

    @Generated
    public void setObjectReferenceId(String objectReferenceId) {
        this.objectReferenceId = objectReferenceId;
    }

    @Generated
    public void setFiles(List<File> files) {
        this.files = files;
    }

    @Generated
    public void setFilesContentType(List<String> filesContentType) {
        this.filesContentType = filesContentType;
    }

    @Generated
    public void setFilesFileName(List<String> filesFileName) {
        this.filesFileName = filesFileName;
    }
}

