/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions.admin;

import com.google.common.base.Strings;
import fr.inra.agrosyst.api.entities.referential.RefActaDosageSPC;
import fr.inra.agrosyst.api.entities.referential.RefActaGroupeCultures;
import fr.inra.agrosyst.api.entities.referential.RefActaSubstanceActive;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduit;
import fr.inra.agrosyst.api.entities.referential.RefActaTraitementsProduitsCateg;
import fr.inra.agrosyst.api.entities.referential.RefAdventice;
import fr.inra.agrosyst.api.entities.referential.RefAgsAmortissement;
import fr.inra.agrosyst.api.entities.referential.RefAnimalType;
import fr.inra.agrosyst.api.entities.referential.RefCattleAnimalType;
import fr.inra.agrosyst.api.entities.referential.RefCattleRationAliment;
import fr.inra.agrosyst.api.entities.referential.RefCiblesAgrosystGroupesCiblesMAA;
import fr.inra.agrosyst.api.entities.referential.RefClonePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefCompositionSubstancesActivesParNumeroAMM;
import fr.inra.agrosyst.api.entities.referential.RefConversionUnitesQSA;
import fr.inra.agrosyst.api.entities.referential.RefCorrespondanceMaterielOutilsTS;
import fr.inra.agrosyst.api.entities.referential.RefCountry;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolAnnuelle;
import fr.inra.agrosyst.api.entities.referential.RefCouvSolPerenne;
import fr.inra.agrosyst.api.entities.referential.RefCultureEdiGroupeCouvSol;
import fr.inra.agrosyst.api.entities.referential.RefDestination;
import fr.inra.agrosyst.api.entities.referential.RefEdaplosTypeTraitement;
import fr.inra.agrosyst.api.entities.referential.RefElementVoisinage;
import fr.inra.agrosyst.api.entities.referential.RefEspeceOtherTools;
import fr.inra.agrosyst.api.entities.referential.RefEspeceToVariete;
import fr.inra.agrosyst.api.entities.referential.RefFeedbackRouter;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.entities.referential.RefFertiOrga;
import fr.inra.agrosyst.api.entities.referential.RefGesCarburant;
import fr.inra.agrosyst.api.entities.referential.RefGesEngrais;
import fr.inra.agrosyst.api.entities.referential.RefGesPhyto;
import fr.inra.agrosyst.api.entities.referential.RefGesSemence;
import fr.inra.agrosyst.api.entities.referential.RefGroupeCibleTraitement;
import fr.inra.agrosyst.api.entities.referential.RefHarvestingPrice;
import fr.inra.agrosyst.api.entities.referential.RefHarvestingPriceConverter;
import fr.inra.agrosyst.api.entities.referential.RefInputUnitPriceUnitConverter;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefInterventionTypeItemInputEDI;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referential.RefMAABiocontrole;
import fr.inra.agrosyst.api.entities.referential.RefMAADosesRefParGroupeCible;
import fr.inra.agrosyst.api.entities.referential.RefMarketingDestination;
import fr.inra.agrosyst.api.entities.referential.RefMaterielAutomoteur;
import fr.inra.agrosyst.api.entities.referential.RefMaterielIrrigation;
import fr.inra.agrosyst.api.entities.referential.RefMaterielOutil;
import fr.inra.agrosyst.api.entities.referential.RefMaterielTraction;
import fr.inra.agrosyst.api.entities.referential.RefMesure;
import fr.inra.agrosyst.api.entities.referential.RefNrjCarburant;
import fr.inra.agrosyst.api.entities.referential.RefNrjGesOutil;
import fr.inra.agrosyst.api.entities.referential.RefNrjPhyto;
import fr.inra.agrosyst.api.entities.referential.RefNrjSemence;
import fr.inra.agrosyst.api.entities.referential.RefNuisibleEDI;
import fr.inra.agrosyst.api.entities.referential.RefOTEX;
import fr.inra.agrosyst.api.entities.referential.RefOrientationEDI;
import fr.inra.agrosyst.api.entities.referential.RefOtherInput;
import fr.inra.agrosyst.api.entities.referential.RefParcelleZonageEDI;
import fr.inra.agrosyst.api.entities.referential.RefPhrasesRisqueEtClassesMentionDangerParAMM;
import fr.inra.agrosyst.api.entities.referential.RefPhytoSubstanceActiveIphy;
import fr.inra.agrosyst.api.entities.referential.RefPot;
import fr.inra.agrosyst.api.entities.referential.RefPrixAutre;
import fr.inra.agrosyst.api.entities.referential.RefPrixCarbu;
import fr.inra.agrosyst.api.entities.referential.RefPrixEspece;
import fr.inra.agrosyst.api.entities.referential.RefPrixFertiMin;
import fr.inra.agrosyst.api.entities.referential.RefPrixFertiOrga;
import fr.inra.agrosyst.api.entities.referential.RefPrixIrrig;
import fr.inra.agrosyst.api.entities.referential.RefPrixPhyto;
import fr.inra.agrosyst.api.entities.referential.RefPrixPot;
import fr.inra.agrosyst.api.entities.referential.RefPrixSubstrate;
import fr.inra.agrosyst.api.entities.referential.RefProtocoleVgObs;
import fr.inra.agrosyst.api.entities.referential.RefQualityCriteria;
import fr.inra.agrosyst.api.entities.referential.RefQualityCriteriaClass;
import fr.inra.agrosyst.api.entities.referential.RefSaActaIphy;
import fr.inra.agrosyst.api.entities.referential.RefSeedUnits;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referential.RefSolCaracteristiqueIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolProfondeurIndigo;
import fr.inra.agrosyst.api.entities.referential.RefSolTextureGeppa;
import fr.inra.agrosyst.api.entities.referential.RefSpeciesToSector;
import fr.inra.agrosyst.api.entities.referential.RefStadeEDI;
import fr.inra.agrosyst.api.entities.referential.RefStadeNuisibleEDI;
import fr.inra.agrosyst.api.entities.referential.RefStationMeteo;
import fr.inra.agrosyst.api.entities.referential.RefStrategyLever;
import fr.inra.agrosyst.api.entities.referential.RefSubstancesActivesCommissionEuropeenne;
import fr.inra.agrosyst.api.entities.referential.RefSubstrate;
import fr.inra.agrosyst.api.entities.referential.RefSupportOrganeEDI;
import fr.inra.agrosyst.api.entities.referential.RefTraitSdC;
import fr.inra.agrosyst.api.entities.referential.RefTypeAgriculture;
import fr.inra.agrosyst.api.entities.referential.RefTypeNotationEDI;
import fr.inra.agrosyst.api.entities.referential.RefUniteEDI;
import fr.inra.agrosyst.api.entities.referential.RefUnitesQualifiantEDI;
import fr.inra.agrosyst.api.entities.referential.RefValeurQualitativeEDI;
import fr.inra.agrosyst.api.entities.referential.RefVarieteGeves;
import fr.inra.agrosyst.api.entities.referential.RefVarietePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefZoneClimatiqueIphy;
import fr.inra.agrosyst.api.entities.referential.ReferentialI18nEntry;
import fr.inra.agrosyst.api.entities.referential.refApi.RefActaDosageSaRoot;
import fr.inra.agrosyst.api.entities.referential.refApi.RefActaDosageSpcRoot;
import fr.inra.agrosyst.api.entities.referential.refApi.RefActaProduitRoot;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.referential.ImportResult;
import fr.inra.agrosyst.api.services.referential.ImportService;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.api.services.users.AuthenticatedUser;
import fr.inra.agrosyst.services.common.EmailService;
import fr.inra.agrosyst.services.referential.csv.RefEspeceDto;
import fr.inra.agrosyst.services.referential.csv.RefLocationExtendedDto;
import fr.inra.agrosyst.services.referential.csv.TypeReferentielCommunes;
import fr.inra.agrosyst.web.actions.admin.AbstractAdminAction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.action.UploadedFilesAware;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

@Results(value={@Result(type="redirectAction", name={"input"}, params={"namespace", "/generic", "actionName", "generic-entities-list", "genericClassName", "${genericClassName}", "importFileError", "true"})})
public class RunImport
extends AbstractAdminAction
implements UploadedFilesAware {
    private static final long serialVersionUID = 4130324772446717782L;
    private static final Log LOGGER = LogFactory.getLog(RunImport.class);
    public static final int MAX_DISPLAYED_MESSAGES = 20;
    protected transient ImportService importService;
    protected transient EmailService emailService;
    protected transient DomainService domainService;
    protected transient ReferentialService referentialService;
    protected String genericClassName;
    protected Class<?> klass;
    protected File source1;
    protected File source2;
    protected String source1FileName;
    protected String source2FileName;
    protected String source1ContentType;
    protected String source2ContentType;
    protected TypeReferentielCommunes typeReferentielCommune;

    public void setImportService(ImportService importService) {
        this.importService = importService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public String getGenericClassName() {
        return this.genericClassName;
    }

    public void setSource1(File source1) {
        this.source1 = source1;
    }

    public void setSource2(File source2) {
        this.source2 = source2;
    }

    public void setSource1FileName(String source1FileName) {
        this.source1FileName = source1FileName;
    }

    public void setSource2FileName(String source2FileName) {
        this.source2FileName = source2FileName;
    }

    public void setSource1ContentType(String source1ContentType) {
        this.source1ContentType = source1ContentType;
    }

    public void setSource2ContentType(String source2ContentType) {
        this.source2ContentType = source2ContentType;
    }

    public TypeReferentielCommunes getTypeReferentielCommune() {
        return this.typeReferentielCommune;
    }

    public void setTypeReferentielCommune(TypeReferentielCommunes typeReferentielCommune) {
        this.typeReferentielCommune = typeReferentielCommune;
    }

    protected void required(File ... sources) {
        if (sources != null) {
            int index = 0;
            for (File source : sources) {
                ++index;
                if (source != null) continue;
                this.addFieldError("source" + index, "Fichier manquant");
            }
        }
    }

    public void validate() {
        if (Strings.isNullOrEmpty((String)this.genericClassName)) {
            this.addFieldError("genericClassName", "Ce champ est obligatoire");
        }
        try {
            this.klass = Class.forName(this.genericClassName);
        }
        catch (ClassNotFoundException e) {
            this.addFieldError("genericClassName", String.format("Classe %s non trouv\u00e9e", this.genericClassName));
        }
        if (RefSolArvalis.class.equals((Object)this.klass)) {
            this.required(new File[]{this.source1, this.source2});
        } else {
            this.required(new File[]{this.source1});
        }
        super.validate();
    }

    @Action(results={@Result(type="redirectAction", params={"namespace", "/generic", "actionName", "generic-entities-list", "genericClassName", "${genericClassName}"})})
    public String execute() throws Exception {
        this.checkIsAdmin();
        ImportResult importResult = null;
        try (FileInputStream stream = new FileInputStream(this.source1);){
            if (RefSolArvalis.class.equals((Object)this.klass)) {
                try (FileInputStream regionsStream = new FileInputStream(this.source2);){
                    importResult = this.importService.importSolArvalisCSV((InputStream)stream, (InputStream)regionsStream);
                }
            }
            if (RefLocationExtendedDto.class.equals((Object)this.klass) && TypeReferentielCommunes.REFERENTIEL_COMMUNE_FRANCE == this.typeReferentielCommune) {
                importResult = this.importService.importCommuneFranceCSV((InputStream)stream);
            } else if (RefLocationExtendedDto.class.equals((Object)this.klass) && TypeReferentielCommunes.REFERENTIEL_COMMUNE_EUROPE == this.typeReferentielCommune) {
                importResult = this.importService.importCommuneEuropeCSV(stream);
            }
            if (RefCountry.class.equals((Object)this.klass)) {
                importResult = this.importService.importCountriesCSV((InputStream)stream);
            }
            if (RefCorrespondanceMaterielOutilsTS.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefCorrespondanceMaterielOutilsTS((InputStream)stream);
            }
            if (RefMaterielTraction.class.equals((Object)this.klass)) {
                importResult = this.importService.importMaterielTracteursCSV((InputStream)stream);
            }
            if (RefMaterielIrrigation.class.equals((Object)this.klass)) {
                importResult = this.importService.importMaterielIrrigationCSV((InputStream)stream);
            }
            if (RefMaterielAutomoteur.class.equals((Object)this.klass)) {
                importResult = this.importService.importMaterielAutomoteursCSV((InputStream)stream);
            }
            if (RefMaterielOutil.class.equals((Object)this.klass)) {
                importResult = this.importService.importMaterielOutilsCSV((InputStream)stream);
            }
            if (RefLegalStatus.class.equals((Object)this.klass)) {
                importResult = this.importService.importLegalStatusCSV((InputStream)stream);
            }
            if (RefEspeceDto.class.equals((Object)this.klass)) {
                importResult = this.importService.importEspeces((InputStream)stream);
            }
            if (RefVarieteGeves.class.equals((Object)this.klass)) {
                importResult = this.importService.importVarietesGeves((InputStream)stream);
            }
            if (RefEspeceToVariete.class.equals((Object)this.klass)) {
                importResult = this.importService.importEspecesToVarietes((InputStream)stream);
            }
            if (RefOTEX.class.equals((Object)this.klass)) {
                importResult = this.importService.importOtexCSV((InputStream)stream);
            }
            if (RefClonePlantGrape.class.equals((Object)this.klass)) {
                importResult = this.importService.importClonesPlantGrape((InputStream)stream);
            }
            if (RefVarietePlantGrape.class.equals((Object)this.klass)) {
                importResult = this.importService.importVarietesPlantGrape((InputStream)stream);
            }
            if (RefOrientationEDI.class.equals((Object)this.klass)) {
                importResult = this.importService.importOrientationEdiCSV((InputStream)stream);
            }
            if (RefSolTextureGeppa.class.equals((Object)this.klass)) {
                importResult = this.importService.importSolTextureGeppa((InputStream)stream);
            }
            if (RefParcelleZonageEDI.class.equals((Object)this.klass)) {
                importResult = this.importService.importZonageParcelleEdi((InputStream)stream);
            }
            if (RefSolProfondeurIndigo.class.equals((Object)this.klass)) {
                importResult = this.importService.importSolProfondeurIndigo((InputStream)stream);
            }
            if (RefSolCaracteristiqueIndigo.class.equals((Object)this.klass)) {
                importResult = this.importService.importSolCarateristiquesIndigo((InputStream)stream);
            }
            if (RefAdventice.class.equals((Object)this.klass)) {
                importResult = this.importService.importAdventices((InputStream)stream);
            }
            if (RefAgsAmortissement.class.equals((Object)this.klass)) {
                importResult = this.importService.importAgsAmortissement((InputStream)stream);
            }
            if (RefNuisibleEDI.class.equals((Object)this.klass)) {
                importResult = this.importService.importNuisiblesEDI((InputStream)stream);
            }
            if (RefFertiMinUNIFA.class.equals((Object)this.klass)) {
                importResult = this.importService.importFertiMinUNIFA((InputStream)stream);
            }
            if (RefFertiOrga.class.equals((Object)this.klass)) {
                importResult = this.importService.importFertiOrga((InputStream)stream);
            }
            if (RefInterventionAgrosystTravailEDI.class.equals((Object)this.klass)) {
                importResult = this.importService.importInterventionAgrosystTravailEdiCSV((InputStream)stream);
            }
            if (RefStadeEDI.class.equals((Object)this.klass)) {
                importResult = this.importService.importStadesEdiCSV((InputStream)stream);
            }
            if (RefUniteEDI.class.equals((Object)this.klass)) {
                importResult = this.importService.importUniteEDI((InputStream)stream);
            }
            if (RefStationMeteo.class.equals((Object)this.klass)) {
                importResult = this.importService.importStationMeteo((InputStream)stream);
            }
            if (RefGesCarburant.class.equals((Object)this.klass)) {
                importResult = this.importService.importGesCarburants((InputStream)stream);
            }
            if (RefGesEngrais.class.equals((Object)this.klass)) {
                importResult = this.importService.importGesEngrais((InputStream)stream);
            }
            if (RefGesPhyto.class.equals((Object)this.klass)) {
                importResult = this.importService.importGesPhyto((InputStream)stream);
            }
            if (RefGesSemence.class.equals((Object)this.klass)) {
                importResult = this.importService.importGesSemences((InputStream)stream);
            }
            if (RefNrjCarburant.class.equals((Object)this.klass)) {
                importResult = this.importService.importNrjCarburants((InputStream)stream);
            }
            if (RefNrjPhyto.class.equals((Object)this.klass)) {
                importResult = this.importService.importNrjPhyto((InputStream)stream);
            }
            if (RefNrjSemence.class.equals((Object)this.klass)) {
                importResult = this.importService.importNrjSemences((InputStream)stream);
            }
            if (RefNrjGesOutil.class.equals((Object)this.klass)) {
                importResult = this.importService.importNrjGesOutils((InputStream)stream);
            }
            if (RefMesure.class.equals((Object)this.klass)) {
                importResult = this.importService.importMesure((InputStream)stream);
            }
            if (RefSupportOrganeEDI.class.equals((Object)this.klass)) {
                importResult = this.importService.importSupportOrganeEDI((InputStream)stream);
            }
            if (RefStadeNuisibleEDI.class.equals((Object)this.klass)) {
                importResult = this.importService.importStadeNuisibleEDI((InputStream)stream);
            }
            if (RefTypeNotationEDI.class.equals((Object)this.klass)) {
                importResult = this.importService.importTypeNotationEDI((InputStream)stream);
            }
            if (RefValeurQualitativeEDI.class.equals((Object)this.klass)) {
                importResult = this.importService.importValeurQualitativeEDI((InputStream)stream);
            }
            if (RefUnitesQualifiantEDI.class.equals((Object)this.klass)) {
                importResult = this.importService.importUnitesQualifiantEDI((InputStream)stream);
            }
            if (RefActaSubstanceActive.class.equals((Object)this.klass)) {
                importResult = this.importService.importActaSubstanceActive((InputStream)stream);
            }
            if (RefProtocoleVgObs.class.equals((Object)this.klass)) {
                importResult = this.importService.importProtocoleVgObs((InputStream)stream);
            }
            if (RefElementVoisinage.class.equals((Object)this.klass)) {
                importResult = this.importService.importElementVoisinage((InputStream)stream);
            }
            if (RefPhytoSubstanceActiveIphy.class.equals((Object)this.klass)) {
                importResult = this.importService.importPhytoSubstanceActiveIphy((InputStream)stream);
            }
            if (RefTypeAgriculture.class.equals((Object)this.klass)) {
                importResult = this.importService.importTypeAgriculture((InputStream)stream);
            }
            if (RefActaGroupeCultures.class.equals((Object)this.klass)) {
                importResult = this.importService.importActaGroupeCultures((InputStream)stream);
            }
            if (RefActaDosageSPC.class.equals((Object)this.klass)) {
                importResult = this.importService.importActaDosageSpc((InputStream)stream);
            }
            if (RefSaActaIphy.class.equals((Object)this.klass)) {
                importResult = this.importService.importSaActaIphy((InputStream)stream);
            }
            if (RefCultureEdiGroupeCouvSol.class.equals((Object)this.klass)) {
                importResult = this.importService.importCultureEdiGroupeCouvSol((InputStream)stream);
            }
            if (RefCouvSolAnnuelle.class.equals((Object)this.klass)) {
                importResult = this.importService.importCouvSolAnnuelle((InputStream)stream);
            }
            if (RefCouvSolPerenne.class.equals((Object)this.klass)) {
                importResult = this.importService.importCouvSolPerenne((InputStream)stream);
            }
            if (RefActaTraitementsProduit.class.equals((Object)this.klass)) {
                importResult = this.importService.importActaTraitementsProduits((InputStream)stream);
            }
            if (RefActaTraitementsProduitsCateg.class.equals((Object)this.klass)) {
                importResult = this.importService.importActaTraitementsProduitsCateg((InputStream)stream);
            }
            if (RefTraitSdC.class.equals((Object)this.klass)) {
                importResult = this.importService.importTraitSdC((InputStream)stream);
            }
            if (RefZoneClimatiqueIphy.class.equals((Object)this.klass)) {
                importResult = this.importService.importZoneClimatiqueIphy((InputStream)stream);
            }
            if (RefActaDosageSpcRoot.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefActaDosageSpcRoot((InputStream)stream);
            }
            if (RefActaDosageSaRoot.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefActaDosageSaRoot((InputStream)stream);
            }
            if (RefActaProduitRoot.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefActaProduitRoot((InputStream)stream);
            }
            if (RefEdaplosTypeTraitement.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefEdaplosTraitementProduit((InputStream)stream);
            }
            if (RefDestination.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefDestination((InputStream)stream);
            }
            if (RefQualityCriteria.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefQualityCriteria((InputStream)stream);
            }
            if (RefHarvestingPrice.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefHarvestingPrice((InputStream)stream);
            }
            if (RefHarvestingPriceConverter.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefHarvestingPriceConverter((InputStream)stream);
            }
            if (RefSpeciesToSector.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefSpeciesToSector((InputStream)stream);
            }
            if (RefStrategyLever.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefStrategyLever((InputStream)stream);
            }
            if (RefAnimalType.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefAnimalType((InputStream)stream);
            }
            if (RefMarketingDestination.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefMarketingDestination((InputStream)stream);
            }
            if (RefInterventionTypeItemInputEDI.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefInternventionTypeItemInputEdi((InputStream)stream);
            }
            if (RefQualityCriteriaClass.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefQualityCriteriaClass((InputStream)stream);
            }
            if (RefPrixCarbu.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefPrixCarbuCSV((InputStream)stream);
            }
            if (RefPrixEspece.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefPrixEspeceCSV((InputStream)stream);
            }
            if (RefPrixFertiMin.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefPrixFertiMinCSV((InputStream)stream);
            }
            if (RefPrixFertiOrga.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefPrixFertiOrgaCSV((InputStream)stream);
            }
            if (RefPrixPhyto.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefPrixPhytoCSV((InputStream)stream);
            }
            if (RefPrixIrrig.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefPrixIrrigCSV((InputStream)stream);
            }
            if (RefPrixAutre.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefPrixAutreCSV((InputStream)stream);
            }
            if (RefInputUnitPriceUnitConverter.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefInputUnitPriceUnitConverterCSV((InputStream)stream);
            }
            if (RefEspeceOtherTools.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefEspeceOtherToolsCSV((InputStream)stream);
            }
            if (RefCattleAnimalType.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefCattleAnimalTypesCSV((InputStream)stream, this.referentialService.getAllActiveRefAnimalTypes());
            }
            if (RefCattleRationAliment.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefCattleRationAlimentsCSV((InputStream)stream);
            }
            if (RefCiblesAgrosystGroupesCiblesMAA.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefCiblesAgrosystGroupesCiblesMAA((InputStream)stream);
            }
            if (RefMAADosesRefParGroupeCible.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefMAADosesRefParGroupeCible((InputStream)stream);
            }
            if (RefMAABiocontrole.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefMAABiocontrole((InputStream)stream);
            }
            if (RefFeedbackRouter.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefFeedbackRouter((InputStream)stream);
            }
            if (RefSubstrate.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefSubstrate((InputStream)stream);
            }
            if (RefPrixSubstrate.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefPrixSubstrate((InputStream)stream);
            }
            if (RefPot.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefPot((InputStream)stream);
            }
            if (RefPrixPot.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefPrixPot((InputStream)stream);
            }
            if (RefGroupeCibleTraitement.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefGroupeCibleTraitement((InputStream)stream);
                this.importService.updateActaTraitementProduitsTraitement();
            }
            if (ReferentialI18nEntry.class.isAssignableFrom(this.klass)) {
                importResult = this.importService.importTraduction(this.klass, (InputStream)stream);
            }
            if (RefOtherInput.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefOtherInputCSV((InputStream)stream);
            }
            if (RefSubstancesActivesCommissionEuropeenne.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefSubstancesActivesCommissionEuropeenneCSV((InputStream)stream);
            }
            if (RefCompositionSubstancesActivesParNumeroAMM.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefCompositionSubstancesActivesParNumeroAMM((InputStream)stream);
            }
            if (RefPhrasesRisqueEtClassesMentionDangerParAMM.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefPhrasesRisqueEtClassesMentionDangerParAMM((InputStream)stream);
            }
            if (RefConversionUnitesQSA.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefConversionUnitesQSA((InputStream)stream);
            }
            if (RefSeedUnits.class.equals((Object)this.klass)) {
                importResult = this.importService.importRefSeedUnits((InputStream)stream);
            }
        }
        if (importResult != null) {
            this.noticeErrors(importResult);
            this.noticeWarnings(importResult);
            this.noticeSuccess(importResult);
            this.sendEmailReportMessages(importResult);
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn((Object)("Can't find valid export for class " + String.valueOf(this.klass)));
        }
        return "success";
    }

    protected void noticeSuccess(ImportResult importResult) {
        if (!importResult.hasErrors()) {
            this.notificationSupport.importSuccess("R\u00c9USSITE : Import termin\u00e9 en %dms. %d cr\u00e9\u00e9(s) - %d modifi\u00e9(s) - %d supprim\u00e9(s) - %d ignor\u00e9(s)", importResult.getDuration(), importResult.getCreated(), importResult.getUpdated(), importResult.getDeleted(), importResult.getIgnored());
        }
    }

    protected void sendEmailReportMessages(ImportResult importResult) {
        try {
            AuthenticatedUser authenticatedUser = this.getAuthenticatedUser();
            this.sendImportReferentialReport(authenticatedUser, this.klass, importResult);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void noticeErrors(ImportResult importResult) {
        List errors = importResult.getErrors();
        if (!errors.isEmpty()) {
            Iterator messageParser = errors.iterator();
            for (int maxDisplayedMessages = 20; messageParser.hasNext() && maxDisplayedMessages > 0; --maxDisplayedMessages) {
                String message = (String)messageParser.next();
                this.notificationSupport.error("\u00c9CHEC : %s", new Object[]{StringUtils.normalizeSpace((String)message)});
            }
            if (errors.size() - 20 > 0) {
                this.notificationSupport.error(String.format("et %d autres erreurs. Veuillez consulter votre bo\u00eete mail pour plus de d\u00e9tail.", errors.size() - 20), new Object[0]);
            }
        }
    }

    protected void noticeWarnings(ImportResult importResult) {
        List warnings = importResult.getWarnings();
        if (!warnings.isEmpty()) {
            this.notificationSupport.warning(String.format("ATTENTION : %d avertissements ont \u00e9t\u00e9 constat\u00e9s. Veuillez consulter votre bo\u00eete mail pour plus de d\u00e9tail.", warnings.size()), new Object[0]);
        }
    }

    protected void sendImportReferentialReport(AuthenticatedUser user, Class<?> klass, ImportResult result) {
        if (!result.hasErrors() && !result.hasWarning()) {
            return;
        }
        InputStream content = this.logMessagesToStream(result.getErrors(), result.getWarnings());
        this.emailService.sendImportReferentialReport(user.getEmail(), klass, result, content);
    }

    protected InputStream logMessagesToStream(List<String> errors, List<String> warnings) {
        ByteArrayInputStream input;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
            for (String error : errors) {
                writer.write(error + "\n");
            }
            for (String warning : warnings) {
                writer.write(warning + "\n");
            }
            ((Writer)writer).close();
            input = new ByteArrayInputStream(out.toByteArray());
        }
        catch (IOException e) {
            throw new AgrosystTechnicalException("Can't export import result", (Throwable)e);
        }
        return input;
    }

    public void withUploadedFiles(List<UploadedFile> uploadedFiles) {
        if (LOGGER.isDebugEnabled()) {
            Collection uploadedFiles1 = CollectionUtils.emptyIfNull(uploadedFiles);
            LOGGER.debug((Object)String.format("L'utilisateur %s \u00e0 envoy\u00e9 les fichiers d'import %s", this.getAuthenticatedUser().getEmail(), uploadedFiles1.stream().map(UploadedFile::getOriginalName).collect(Collectors.joining())));
        }
    }
}

