/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions;

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.services.context.NavigationContextService;
import fr.inra.agrosyst.api.utils.DaoUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class RichNavigationContext {
    protected static final Function<Integer, String> GET_CAMPAIGN_NAME = campaign -> String.format("%d (%d - %d)", campaign, campaign - 1, campaign);
    protected final NavigationContext navigationContext;
    protected final NavigationContextService navigationContextService;

    public RichNavigationContext(NavigationContext navigationContext, NavigationContextService navigationContextService) {
        this.navigationContext = navigationContext;
        this.navigationContextService = navigationContextService;
    }

    public int getCampaignsCount() {
        return this.navigationContext.getCampaignsCount();
    }

    public Map<Integer, String> getCampaigns() {
        int index = 0;
        int max = Integer.MAX_VALUE;
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Integer campaign : this.navigationContext.getCampaigns()) {
            if (index >= max) break;
            ++index;
            result.put(campaign, (String)GET_CAMPAIGN_NAME.apply(campaign));
        }
        return result;
    }

    public int getNetworksCount() {
        return this.navigationContext.getNetworksCount();
    }

    public Map<String, String> getNetworks() {
        return this.navigationContextService.getNetworks(this.navigationContext.getNetworks(), DaoUtils.NO_PAGE_LIMIT.intValue());
    }

    public int getDomainsCount() {
        return this.navigationContext.getDomainsCount();
    }

    public Map<String, String> getDomains() {
        return this.navigationContextService.getDomains(this.navigationContext.getDomains(), DaoUtils.NO_PAGE_LIMIT.intValue());
    }

    public int getGrowingPlansCount() {
        return this.navigationContext.getGrowingPlansCount();
    }

    public Map<String, String> getGrowingPlans() {
        return this.navigationContextService.getGrowingPlans(this.navigationContext.getGrowingPlans(), DaoUtils.NO_PAGE_LIMIT.intValue());
    }

    public int getGrowingSystemsCount() {
        return this.navigationContext.getGrowingSystemsCount();
    }

    public Map<String, String> getGrowingSystems() {
        return this.navigationContextService.getGrowingSystems(this.navigationContext.getGrowingSystems(), DaoUtils.NO_PAGE_LIMIT.intValue());
    }
}

