/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web.actions;

import fr.inra.agrosyst.api.Language;
import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.entities.referential.FeedbackCategory;
import fr.inra.agrosyst.services.common.AgrosystI18nService;
import fr.inra.agrosyst.web.actions.FeedbackCategoryDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.nuiton.i18n.I18n;

public class AgrosystLayoutData {
    protected boolean currentUserAnAdmin;
    protected boolean currentUserAnIsDataProcessor;
    protected String currentUserLastName;
    protected String currentUserFirstName;
    protected String currentUserBannerPath;
    protected String currentUserBannerMeta;
    protected String currentUserItEmail;
    protected Language currentUserLanguage;
    protected NavigationContext navigationContext;
    protected Map<Integer, String> campaigns;
    protected Map<String, String> networks;
    protected Map<String, String> domains;
    protected Map<String, String> growingPlans;
    protected Map<String, String> growingSystems;

    public void setCurrentUserAnAdmin(boolean currentUserAnAdmin) {
        this.currentUserAnAdmin = currentUserAnAdmin;
    }

    public void setCurrentUserAnIsDataProcessor(boolean currentUserAnIsDataProcessor) {
        this.currentUserAnIsDataProcessor = currentUserAnIsDataProcessor;
    }

    public void setCurrentUserLastName(String currentUserLastName) {
        this.currentUserLastName = currentUserLastName;
    }

    public void setCurrentUserFirstName(String currentUserFirstName) {
        this.currentUserFirstName = currentUserFirstName;
    }

    public boolean isCurrentUserAnAdmin() {
        return this.currentUserAnAdmin;
    }

    public boolean isCurrentUserAnIsDataProcessor() {
        return this.currentUserAnIsDataProcessor;
    }

    public String getCurrentUserLastName() {
        return this.currentUserLastName;
    }

    public String getCurrentUserFirstName() {
        return this.currentUserFirstName;
    }

    public String getCurrentUserBannerPath() {
        return this.currentUserBannerPath;
    }

    public void setCurrentUserBannerPath(String currentUserBannerPath) {
        this.currentUserBannerPath = currentUserBannerPath;
    }

    public String getCurrentUserBannerMeta() {
        return this.currentUserBannerMeta;
    }

    public void setCurrentUserBannerMeta(String currentUserBannerMeta) {
        this.currentUserBannerMeta = currentUserBannerMeta;
    }

    public String getCurrentUserItEmail() {
        return this.currentUserItEmail;
    }

    public void setCurrentUserItEmail(String currentUserItEmail) {
        this.currentUserItEmail = currentUserItEmail;
    }

    public Language getCurrentUserLanguage() {
        return this.currentUserLanguage;
    }

    public void setCurrentUserLanguage(Language currentUserLanguage) {
        this.currentUserLanguage = currentUserLanguage;
    }

    public void setNavigationContext(NavigationContext navigationContext) {
        this.navigationContext = navigationContext;
    }

    public void setCampaigns(Map<Integer, String> campaigns) {
        this.campaigns = campaigns;
    }

    public void setNetworks(Map<String, String> networks) {
        this.networks = networks;
    }

    public void setDomains(Map<String, String> domains) {
        this.domains = domains;
    }

    public void setGrowingPlans(Map<String, String> growingPlans) {
        this.growingPlans = growingPlans;
    }

    public void setGrowingSystems(Map<String, String> growingSystems) {
        this.growingSystems = growingSystems;
    }

    public int getCampaignsCount() {
        return this.navigationContext.getCampaignsCount();
    }

    public int getNetworksCount() {
        return this.navigationContext.getNetworksCount();
    }

    public int getDomainsCount() {
        return this.navigationContext.getDomainsCount();
    }

    public int getGrowingPlansCount() {
        return this.navigationContext.getGrowingPlansCount();
    }

    public int getGrowingSystemsCount() {
        return this.navigationContext.getGrowingSystemsCount();
    }

    public Map<Integer, String> getCampaigns() {
        return this.campaigns;
    }

    public Map<String, String> getNetworks() {
        return this.networks;
    }

    public Map<String, String> getDomains() {
        return this.domains;
    }

    public Map<String, String> getGrowingPlans() {
        return this.growingPlans;
    }

    public Map<String, String> getGrowingSystems() {
        return this.growingSystems;
    }

    protected List<FeedbackCategoryDto> getFeedbackCategories(FeedbackCategory ... feedbackCategories) {
        Locale l = Optional.ofNullable(this.currentUserLanguage).map(Language::getLocale).orElse(AgrosystI18nService.getDefaultLocale());
        ArrayList<FeedbackCategoryDto> result = new ArrayList<FeedbackCategoryDto>();
        Map res0 = AgrosystI18nService.getEnumAsMap((Locale)l, (String)"FeedbackCategory", (Object[])feedbackCategories);
        for (Map.Entry feedbackCategoryToTrad : res0.entrySet()) {
            String help = I18n.l((Locale)l, (String)(FeedbackCategory.class.getName() + "." + ((FeedbackCategory)feedbackCategoryToTrad.getKey()).name() + "#help"), (Object[])new Object[0]);
            FeedbackCategoryDto feedbackCategoryDto = new FeedbackCategoryDto((FeedbackCategory)feedbackCategoryToTrad.getKey(), (String)feedbackCategoryToTrad.getValue(), help);
            result.add(feedbackCategoryDto);
        }
        return result;
    }

    public List<FeedbackCategoryDto> getAgrosystFeedbackCategories() {
        return this.getFeedbackCategories(new FeedbackCategory[]{FeedbackCategory.FONCTIONNEMENT_AGROSYST, FeedbackCategory.CONSIGNES_SAISIES, FeedbackCategory.ETAT_LIEUX_SAISIES, FeedbackCategory.REFERENTIELS, FeedbackCategory.EVOLUTION, FeedbackCategory.GESTION_COMPTE, FeedbackCategory.DECALAGE_DONNEES, FeedbackCategory.LOCAL_INTRANTS, FeedbackCategory.EDAPLOS, FeedbackCategory.BUG});
    }

    public List<FeedbackCategoryDto> getIpmWorksFeedbackCategories() {
        return this.getFeedbackCategories(new FeedbackCategory[]{FeedbackCategory.FONCTIONNEMENT_AGROSYST, FeedbackCategory.CONSIGNES_SAISIES, FeedbackCategory.REFERENTIELS, FeedbackCategory.EVOLUTION, FeedbackCategory.GESTION_COMPTE, FeedbackCategory.BUG});
    }

    protected Map<Sector, String> getSectorTypes(Sector ... sectors) {
        Locale l = Optional.ofNullable(this.currentUserLanguage).map(Language::getLocale).orElse(AgrosystI18nService.getDefaultLocale());
        return AgrosystI18nService.getEnumAsMap((Locale)l, null, (Object[])sectors);
    }

    public Map<Sector, String> getAgrosystSectorTypes() {
        return this.getSectorTypes(Sector.values());
    }

    public Map<Sector, String> getIpmWorksSectorTypes() {
        return this.getSectorTypes(new Sector[]{Sector.ARBORICULTURE, Sector.HORTICULTURE, Sector.MARAICHAGE, Sector.GRANDES_CULTURES, Sector.POLYCULTURE_ELEVAGE, Sector.VITICULTURE});
    }

    public Map<TypeDEPHY, String> getDephyTypes() {
        Locale l = Optional.ofNullable(this.currentUserLanguage).map(Language::getLocale).orElse(AgrosystI18nService.getDefaultLocale());
        return AgrosystI18nService.getEnumAsMap((Locale)l, null, (Object[])new TypeDEPHY[]{TypeDEPHY.DEPHY_FERME, TypeDEPHY.DEPHY_EXPE, TypeDEPHY.NOT_DEPHY});
    }

    public String getItEmail() {
        return this.currentUserItEmail;
    }
}

