/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.web;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import fr.inra.agrosyst.api.entities.AgrosystTopiaApplicationContext;
import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.api.services.users.AuthenticatedUser;
import fr.inra.agrosyst.services.AgrosystConfigurationHelper;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import fr.inra.agrosyst.web.AgrosystWebConfig;
import fr.inra.agrosyst.web.AgrosystWebDistributedCacheSupport;
import fr.inra.agrosyst.web.CookieHelper;
import fr.inra.agrosyst.web.actions.security.JwtHelper;
import fr.inra.agrosyst.web.listeners.AgrosystWebApplicationListener;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.topia.persistence.TopiaConfiguration;

public class AgrosystWebApplicationContext {
    private static final Log LOGGER = LogFactory.getLog(AgrosystWebApplicationContext.class);
    public static final LocalDateTime RUNNING_SINCE = LocalDateTime.now();
    public static final String APPLICATION_CONTEXT_PARAMETER = AgrosystWebApplicationContext.class.getName();
    public static final String CONFIG_FILE_PREFIX = "agrosyst-";
    public static final String CONFIG_FILE_EXT = ".properties";
    public static final String DEFAULT_CONTEXT_NAME = "ROOT";
    public static final String MISSING_APPLICATION_CONTEXT = AgrosystWebApplicationContext.class.getSimpleName() + " not found. You probably forgot to register " + AgrosystWebApplicationListener.class.getName() + " in your web.xml";
    public static final String TOKEN_COOKIE_NAME = "X-Agrosyst-Token";
    public static final String SEPARATOR = "/";
    protected final AgrosystWebConfig webConfig;
    protected final AgrosystServiceConfig serviceConfig;
    protected final AgrosystTopiaApplicationContext applicationContext;
    protected final String configFileName;
    protected final AgrosystWebDistributedCacheSupport distributedCacheSupport;
    protected final Map<String, String[]> bannersMap = new HashMap();

    public AgrosystWebApplicationContext(ServletContext servletContext) {
        I18n.init((I18nInitializer)new DefaultI18nInitializer("agrosyst-web"), (Locale)Locale.FRANCE);
        this.configFileName = this.getConfigFileName(servletContext);
        LOGGER.info((Object)("Load config file name:" + this.configFileName));
        this.webConfig = new AgrosystWebConfig(this.configFileName);
        try {
            this.serviceConfig = new AgrosystServiceConfig(this.configFileName);
            Properties contextProperties = this.serviceConfig.getFlatOptions();
            TopiaConfiguration topiaConfiguration = AgrosystConfigurationHelper.getPersistanceConfiguration((Properties)contextProperties);
            this.applicationContext = AgrosystConfigurationHelper.newApplicationContext((AgrosystServiceConfig)this.serviceConfig, (TopiaConfiguration)topiaConfiguration);
        }
        catch (Exception eee) {
            throw new AgrosystTechnicalException("An exception occurred", (Throwable)eee);
        }
        this.distributedCacheSupport = new AgrosystWebDistributedCacheSupport(this.webConfig);
    }

    public void reloadConfig() {
        this.webConfig.reloadConfig();
    }

    private String getConfigFileName(ServletContext servletContext) {
        String configFileName = servletContext.getContextPath();
        if (configFileName != null) {
            String baseName = StringUtils.remove((String)configFileName, (String)SEPARATOR);
            if (StringUtils.isBlank((CharSequence)baseName)) {
                baseName = DEFAULT_CONTEXT_NAME;
            }
            configFileName = StringUtils.join((Object[])new String[]{CONFIG_FILE_PREFIX, baseName, CONFIG_FILE_EXT});
        }
        return configFileName;
    }

    public void initApplicationBanners(ServletContext servletContext) {
        Set resources = servletContext.getResourcePaths("/img/Header-Backgrounds/");
        for (String resource : resources) {
            String extension = FilenameUtils.getExtension((String)resource);
            String baseName = FilenameUtils.getBaseName((String)resource);
            if (!"jpg".equals(extension)) continue;
            String metaPath = resource.replace("." + extension, ".txt");
            try {
                InputStream metaStream = servletContext.getResourceAsStream(metaPath);
                try {
                    String metaContent = IOUtils.toString((InputStream)metaStream, (Charset)Charset.defaultCharset());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Adding banner " + baseName + "(" + metaContent + ")"));
                    }
                    String resourceContextPath = StringUtils.removeStart((String)resource, (String)SEPARATOR);
                    this.bannersMap.put(baseName, new String[]{resourceContextPath, metaContent});
                }
                finally {
                    if (metaStream == null) continue;
                    metaStream.close();
                }
            }
            catch (IOException ex) {
                throw new AgrosystTechnicalException("Can't read banner metadata", (Throwable)ex);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Detecting " + this.bannersMap.size() + " banners"));
        }
    }

    public AgrosystWebConfig getWebConfig() {
        return this.webConfig;
    }

    public AgrosystServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    public AgrosystTopiaApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Map<String, String[]> getBannersMap() {
        return this.bannersMap;
    }

    public void close() {
        if (this.applicationContext != null && !this.applicationContext.isClosed()) {
            this.applicationContext.close();
        }
        if (this.distributedCacheSupport != null) {
            this.distributedCacheSupport.shutdown();
        }
    }

    public <K, V> Map<K, V> getDistributedCache(String name) {
        Map result = this.distributedCacheSupport.getCache(name);
        return result;
    }

    public Map<String, String> getSessionsCache() {
        int timeoutSeconds = this.webConfig.getHttpSessionTimeout();
        Map result = this.distributedCacheSupport.getCacheWithExpiration("sessions", timeoutSeconds);
        return result;
    }

    public Optional<String> readAuthenticationCookie(CookieHelper cookieHelper) {
        Optional result = cookieHelper.readCookie(TOKEN_COOKIE_NAME);
        return result;
    }

    public void writeAuthenticationCookie(AuthenticatedUser authenticatedUser, CookieHelper cookieHelper) {
        JwtHelper jwtHelper = new JwtHelper(this.webConfig);
        int maxAge = this.webConfig.getHttpSessionTimeout() + this.webConfig.getJwtRefreshSeconds();
        cookieHelper.writeCookie(TOKEN_COOKIE_NAME, (Object)authenticatedUser, arg_0 -> ((JwtHelper)jwtHelper).createJwtToken(arg_0), maxAge, true);
        Map sessions = this.getSessionsCache();
        String userIdHashed = Hashing.murmur3_128().hashString((CharSequence)authenticatedUser.getTopiaId(), Charsets.UTF_8).toString();
        sessions.put(authenticatedUser.getSid(), userIdHashed);
    }

    public void doLogout(Optional<AuthenticatedUser> authenticatedUser, CookieHelper cookieHelper) {
        cookieHelper.deleteCookie(TOKEN_COOKIE_NAME);
        authenticatedUser.map(AuthenticatedUser::getSid).ifPresent(sid -> this.getSessionsCache().remove(sid));
    }
}

