/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.imprt.domain;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.WeatherStationTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatusTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLocationTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefOTEXTopiaDao;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.imprt.AbstractCSVImporter;
import fr.inra.agrosyst.services.imprt.domain.DomainImportDto;
import fr.inra.agrosyst.services.imprt.domain.DomainImportModel;
import java.io.InputStream;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;

public class DomainImporter
extends AbstractCSVImporter {
    private static final Log log = LogFactory.getLog(DomainImporter.class);
    private DomainService domainService;
    private DomainTopiaDao domainTopiaDao;
    private RefLocationTopiaDao locationDao;
    private RefLegalStatusTopiaDao refLegalStatusDao;
    private WeatherStationTopiaDao weatherStationDao;
    private RefOTEXTopiaDao refOtexDao;
    private int updatedRecords = 0;
    private int createdRecords = 0;
    private int ignoredRecords = 0;

    public DomainImporter(InputStream is) {
        this.is = is;
    }

    private Domain holdDomainForNaturalId(int campaign, String code) {
        Domain domain = (Domain)this.domainTopiaDao.forNaturalId(campaign, code).findUniqueOrNull();
        if (domain == null) {
            domain = (Domain)this.domainTopiaDao.newInstance();
            domain.setCampaign(campaign);
            domain.setCode(code);
            domain.setName("Domaine test Estelle");
            domain.setMainContact("Estelle");
            domain.setType(DomainType.DOMAINE_EXPERIMENTAL);
            ++this.createdRecords;
        } else {
            ++this.updatedRecords;
        }
        return domain;
    }

    @Override
    public void importFromStream() {
        DomainImportModel model = new DomainImportModel();
        Import importer = Import.newImport((ImportModel)model, (InputStream)this.is);
        for (DomainImportDto dto : importer) {
            Domain domain = this.holdDomainForNaturalId(dto.getCampaign(), dto.getCode());
            this.domainService.createOrUpdateDomain(domain, "fr.inra.agrosyst.api.entities.referential.RefLocation_001036fd-7cba-4b40-8f84-875ea7fa0cd0", null, null, null, null, null, null, null, null, null);
            this.cacheMap.put(Domain.class, (Object)dto.getId(), (Object)domain.getTopiaId());
        }
        log.info((Object)String.format("%d domaines ont \u00e9t\u00e9 cr\u00e9es.", this.createdRecords));
        log.info((Object)String.format("%d domaines ont \u00e9t\u00e9 mis \u00e0 jour.", this.updatedRecords));
        log.info((Object)String.format("%d domaines ont \u00e9t\u00e9 ignor\u00e9s.", this.ignoredRecords));
    }

    @Override
    public void init(ServiceContext serviceContext, MultiKeyMap cacheMap) {
        super.init(serviceContext, cacheMap);
        this.domainTopiaDao = this.getPersistenceContext().getDomainDao();
        this.domainService = (DomainService)this.getServiceFactory().newService(DomainService.class);
    }
}

