/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.imprt;

import fr.inra.agrosyst.api.entities.AgrosystTopiaPersistenceContext;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.AgrosystUserTopiaDao;
import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.entities.security.UserRoleTopiaDao;
import fr.inra.agrosyst.api.services.ServiceFactory;
import fr.inra.agrosyst.api.services.security.AuthenticationService;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.imprt.CliServiceContext;
import fr.inra.agrosyst.services.imprt.ICsvImporter;
import fr.inra.agrosyst.services.imprt.domain.DomainImporter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections4.map.MultiKeyMap;

public class CliStarter {
    private final ServiceFactory serviceFactory;
    private final ServiceContext serviceContext = new CliServiceContext();

    public CliStarter() {
        this.serviceFactory = ((CliServiceContext)this.serviceContext).getServiceFactory();
    }

    public AgrosystTopiaPersistenceContext getPersistenceContext(boolean create) {
        return this.serviceContext.getPersistenceContext(create);
    }

    public AgrosystTopiaPersistenceContext getPersistenceContext() {
        return this.serviceContext.getPersistenceContext();
    }

    protected void loginAsAdmin() {
        AgrosystUserTopiaDao userTopiaDao = this.getPersistenceContext(true).getAgrosystUserDao();
        if (!userTopiaDao.forEmailEquals("admin@test.fr").tryFindAny().isPresent()) {
            UserService userService = (UserService)this.serviceFactory.newService(UserService.class);
            UserDto user = new UserDto();
            user.setActive(true);
            user.setEmail("admin@test.fr");
            user.setFirstName("Admin");
            user.setLastName("Test");
            user = userService.createUser(user, "azerty");
            AgrosystUser userEntity = (AgrosystUser)userTopiaDao.forTopiaIdEquals(user.getTopiaId()).findUnique();
            UserRoleTopiaDao userRoleTopiaDao = this.getPersistenceContext().getUserRoleDao();
            userRoleTopiaDao.create("agrosystUser", (Object)userEntity, new Object[]{"type", RoleType.ADMIN});
        }
        this.loginUser("admin@test.fr", "azerty");
    }

    protected UserDto loginUser(String login, String password) {
        AuthenticationService authenticationService = (AuthenticationService)this.serviceFactory.newService(AuthenticationService.class);
        UserDto authUser = authenticationService.login(login, password);
        ((CliServiceContext)this.serviceContext).setAuthenticationToken(authUser.getAuthenticationToken());
        return authUser;
    }

    public void start() {
        this.loginAsAdmin();
        MultiKeyMap cacheMap = new MultiKeyMap();
        try {
            LinkedList<DomainImporter> importers = new LinkedList<DomainImporter>();
            importers.add(new DomainImporter(new FileInputStream("/home/eancelet/Agrosyst/Imports_ETL/essai_pz/NMJ/domain_NMJ.csv")));
            for (ICsvImporter iCsvImporter : importers) {
                iCsvImporter.init(this.serviceContext, cacheMap);
                iCsvImporter.importFromStream();
            }
            this.getPersistenceContext().commit();
        }
        catch (FileNotFoundException ex) {
            this.getPersistenceContext().rollback();
            Logger.getLogger(CliStarter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception e) {
            this.getPersistenceContext().rollback();
            System.out.println("rollback");
        }
        ((CliServiceContext)this.serviceContext).cleanup();
    }

    public static void main(String[] args) {
        CliStarter importer = new CliStarter();
        importer.start();
    }
}

