/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.agrosyst.services.imprt;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.AgrosystTopiaApplicationContext;
import fr.inra.agrosyst.api.entities.AgrosystTopiaDaoSupplier;
import fr.inra.agrosyst.api.entities.AgrosystTopiaPersistenceContext;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.ServiceFactory;
import fr.inra.agrosyst.commons.gson.AgrosystGsonSupplier;
import fr.inra.agrosyst.services.AgrosystConfigurationHelper;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import fr.inra.agrosyst.services.DefaultServiceFactory;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.common.ProjectionHelper;
import fr.inra.agrosyst.services.security.SecurityContext;
import java.lang.reflect.Method;
import java.sql.Driver;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.PostgreSQL9Dialect;
import org.nuiton.topia.persistence.TopiaApplicationContextCache;
import org.nuiton.topia.persistence.TopiaTransaction;

public class CliServiceContext
implements ServiceContext {
    private static final Log log = LogFactory.getLog(CliServiceContext.class);
    protected static final Long TEST_RUN_ID = System.currentTimeMillis();
    protected Method testMethod;
    protected AgrosystTopiaPersistenceContext transaction;
    protected AgrosystTopiaApplicationContext rootContext;
    protected ServiceFactory serviceFactory = new DefaultServiceFactory((ServiceContext)this);
    protected AgrosystServiceConfig config;
    protected String authenticationToken;
    protected SecurityContext securityContext;
    protected ProjectionHelper projectionHelper;

    public CliServiceContext() {
        Properties properties = new Properties();
        properties.setProperty("hibernate.hbm2ddl.auto", "update");
        properties.setProperty("hibernate.dialect", PostgreSQL9Dialect.class.getName());
        properties.setProperty("hibernate.connection.driver_class", Driver.class.getName());
        String jdbcUrl = "jdbc:postgresql:agrosyst-cli";
        log.debug((Object)String.format("L'URL JDBC utilis\u00e9e est \"%s\"", jdbcUrl));
        properties.setProperty("hibernate.connection.url", jdbcUrl);
        properties.setProperty("hibernate.connection.username", "agrosyst");
        properties.setProperty("hibernate.connection.password", "agrosyst");
        properties.setProperty("hibernate.current_session_context_class", "thread");
        properties.setProperty("hibernate.c3p0.min_size", "5");
        properties.setProperty("hibernate.c3p0.max_size", "20");
        properties.setProperty("hibernate.c3p0.timeout", "300");
        properties.setProperty("hibernate.c3p0.max_statements", "50");
        properties.setProperty("topia.persistence.initSchema", "false");
        properties.setProperty("topia.persistence.classes", AgrosystEntityEnum.getImplementationClassesAsString());
        this.rootContext = (AgrosystTopiaApplicationContext)TopiaApplicationContextCache.getContext((Properties)properties, (Function)AgrosystConfigurationHelper.getCreateTopiaContextFunction((AgrosystServiceConfig)this.getConfig()));
    }

    public void setAuthenticationToken(String authenticationToken) {
        this.authenticationToken = authenticationToken;
        if (!Strings.isNullOrEmpty((String)authenticationToken)) {
            this.securityContext = null;
        }
    }

    public ServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public ServiceContext newServiceContext() {
        return this;
    }

    public void close() {
    }

    public Date getCurrentDate() {
        return new Date();
    }

    public TopiaTransaction getTransaction() {
        TopiaTransaction result = this.getTransaction(true);
        return result;
    }

    public TopiaTransaction getTransaction(boolean create) {
        AgrosystTopiaPersistenceContext result = this.getTransaction0(create);
        return result;
    }

    public AgrosystTopiaDaoSupplier getDaoSupplier() {
        AgrosystTopiaPersistenceContext result = this.getTransaction0(true);
        return result;
    }

    public AgrosystTopiaPersistenceContext getPersistenceContext() {
        AgrosystTopiaPersistenceContext result = this.getTransaction0(false);
        return result;
    }

    public AgrosystTopiaPersistenceContext getPersistenceContext(boolean create) {
        AgrosystTopiaPersistenceContext result = this.getTransaction0(create);
        return result;
    }

    private AgrosystTopiaPersistenceContext getTransaction0(boolean create) {
        Preconditions.checkState((this.rootContext != null ? 1 : 0) != 0);
        if (this.transaction == null && create) {
            this.transaction = this.rootContext.newPersistenceContext();
        }
        return this.transaction;
    }

    public <E extends AgrosystService> E newService(Class<E> clazz) {
        return (E)this.serviceFactory.newService(clazz);
    }

    public <I> I newInstance(Class<I> clazz) {
        return (I)this.serviceFactory.newInstance(clazz);
    }

    public AgrosystServiceConfig getConfig() {
        if (this.config == null) {
            this.config = new AgrosystServiceConfig("agrosyst-toto.properties");
        }
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (this.transaction != null && !this.transaction.isClosed()) {
            try {
                this.transaction.rollback();
            }
            finally {
                this.transaction.close();
            }
        }
        this.transaction = null;
        if (!this.rootContext.isClosed()) {
            this.rootContext.close();
        }
        this.serviceFactory = null;
        this.securityContext = null;
    }

    public SecurityContext getSecurityContext() {
        if (this.securityContext == null) {
            this.securityContext = new SecurityContext(this.getServiceFactory(), this.authenticationToken);
        }
        return this.securityContext;
    }

    public SecurityContext getSecurityContextAsUser(String userId) {
        SecurityContext securityContext = new SecurityContext(this.getServiceFactory(), this.authenticationToken, userId);
        return securityContext;
    }

    public Gson getGson() {
        return new AgrosystGsonSupplier().get();
    }
}

