/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package fr.inra.agrosyst.services.imprt;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: AbstractAgrosystModelExtended.java 4440 2014-10-16 17:25:26Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.3.0.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/imprt/AbstractAgrosystModelExtended.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.TypeDEPHY;
import fr.inra.agrosyst.api.entities.Zoning;
import fr.inra.agrosyst.api.entities.managementmode.CategoryStrategy;
import fr.inra.agrosyst.services.referential.csv.AbstractAgrosystModel;

import java.text.ParseException;

import org.nuiton.csv.ValueParser;

/**
 *
 * @author schellen
 */
public abstract class AbstractAgrosystModelExtended<E> extends AbstractAgrosystModel<E> {

    protected AbstractAgrosystModelExtended(char separator) {
        super(separator);
    }

    protected static final ValueParser<DomainType> AGROSYST_DOMAIN_TYPE_PARSER = new ValueParser<DomainType>() {
        @Override
        public DomainType parse(String value) throws ParseException {
            DomainType result = null;
            if (!Strings.isNullOrEmpty(value)) {
                if (value.equalsIgnoreCase("exploitation_agricole")) {
                    result = DomainType.EXPLOITATION_AGRICOLE;
                } else if (value.equalsIgnoreCase("domaine_experimental")) {
                    result = DomainType.DOMAINE_EXPERIMENTAL;;
                } else if (value.equalsIgnoreCase("ferme_de_lycee_agricole")) {
                    result = DomainType.FERME_DE_LYCEE_AGRICOLE;;
                } else {
                    throw new UnsupportedOperationException("Type de domaine non supporté : " + value);
                }
            }
            return result;
        }
    };

    protected static final ValueParser<Zoning> AGROSYST_ZONING_PARSER = new ValueParser<Zoning>() {
        @Override
        public Zoning parse(String value) throws ParseException {
            Zoning result = null;

            if (!Strings.isNullOrEmpty(value)) {
                if (value.equalsIgnoreCase("ZONE_DE_PLAINE")) {
                    result = Zoning.ZONE_DE_PLAINE;
                } else if (value.equalsIgnoreCase("ZONE_DEFAVORISEE_SIMPLE")) {
                    result = Zoning.ZONE_DEFAVORISEE_SIMPLE;
                } else if (value.equalsIgnoreCase("ZONE_DE_MONTAGNE")) {
                    result = Zoning.ZONE_DE_MONTAGNE;
                } else if (value.equalsIgnoreCase("ZONE_DE_PIEMONT")) {
                    result = Zoning.ZONE_DE_PIEMONT;
                } else {
                    throw new UnsupportedOperationException("Zoning non supportée : " + value);
                }
            }
            return result;
        }
    };
    
    protected static final ValueParser<TypeDEPHY> AGROSYST_TYPE_DEPHY_PARSER = new ValueParser<TypeDEPHY>() {
        @Override
        public TypeDEPHY parse(String value) throws ParseException {
            TypeDEPHY result = null;

            if (!Strings.isNullOrEmpty(value)) {
                if (value.equalsIgnoreCase("FERME")) {
                    result = TypeDEPHY.FERME;
                } else if (value.equalsIgnoreCase("expe")) {
                    result = TypeDEPHY.EXPE;
                } else {
                    throw new UnsupportedOperationException("Type DEPHY non supporté : " + value);
                }
            }
            return result;
        }
    };
    
    protected static final ValueParser<Sector> AGROSYST_SECTOR_PARSER = new ValueParser<Sector>() {
        @Override
        public Sector parse(String value) throws ParseException {
            Sector result = null;

            if (!Strings.isNullOrEmpty(value)) {
                if (value.equalsIgnoreCase("GRANDES_CULTURES")) {
                    result = Sector.GRANDES_CULTURES;
                } else if (value.equalsIgnoreCase("POLYCULTURE_ELEVAGE")) {
                    result = Sector.POLYCULTURE_ELEVAGE;
                } else if (value.equalsIgnoreCase("VITICULTURE")) {
                    result = Sector.VITICULTURE;
                } else if (value.equalsIgnoreCase("ARBORICULTURE")) {
                    result = Sector.ARBORICULTURE;
                } else if (value.equalsIgnoreCase("MARAICHAGE")) {
                    result = Sector.MARAICHAGE;
                } else if (value.equalsIgnoreCase("HORTICULTURE")) {
                    result = Sector.HORTICULTURE;
                } else if (value.equalsIgnoreCase("CULTURES_TROPICALES")) {
                    result = Sector.CULTURES_TROPICALES;
                } else {
                    throw new UnsupportedOperationException("Filière (growingsystem.sector) non supportée : " + value);
                }
            }
            return result;
        }
    };
    
    
    protected static final ValueParser<CategoryStrategy> AGROSYST_CATEGORY_STRATEGY_PARSER = new ValueParser<CategoryStrategy>() {
        @Override
        public CategoryStrategy parse(String value) throws ParseException {
            CategoryStrategy result = null;

            if (!Strings.isNullOrEmpty(value)) {
                if (value.equalsIgnoreCase("EFFICIENCE")) {
                    result = CategoryStrategy.EFFICIENCE;
                } else if (value.equalsIgnoreCase("SUBSTITUTION")) {
                    result = CategoryStrategy.SUBSTITUTION;
                } else if (value.equalsIgnoreCase("RECONCEPTION")) {
                    result = CategoryStrategy.RECONCEPTION;
                } else if (value.equalsIgnoreCase("RECONCEPTION_EFFICIENCE")) {
                    result = CategoryStrategy.RECONCEPTION_EFFICIENCE;
                } else if (value.equalsIgnoreCase("AUTRE")) {
                    result = CategoryStrategy.AUTRE;
                } else {
                    throw new UnsupportedOperationException("Catégorie de stratégie : (growingsystem.categoryStrategy), non supportée : " + value);
                }
            }
            return result;
        }
    };

    
}
