/*
 * Decompiled with CFR 0.152.
 */
package persistence.antlr.preprocessor;

import java.io.IOException;
import java.util.Enumeration;
import persistence.antlr.CodeGenerator;
import persistence.antlr.Tool;
import persistence.antlr.collections.impl.IndexedVector;
import persistence.antlr.preprocessor.GrammarFile;
import persistence.antlr.preprocessor.Hierarchy;
import persistence.antlr.preprocessor.Option;
import persistence.antlr.preprocessor.Rule;

class Grammar {
    protected String name;
    protected String fileName;
    protected String superGrammar;
    protected String type;
    protected IndexedVector rules;
    protected IndexedVector options;
    protected String tokenSection;
    protected String preambleAction;
    protected String memberAction;
    protected Hierarchy hier;
    protected boolean predefined = false;
    protected boolean alreadyExpanded = false;
    protected boolean specifiedVocabulary = false;
    protected String superClass = null;
    protected String importVocab = null;
    protected String exportVocab = null;
    protected Tool antlrTool;

    public Grammar(Tool tool, String name, String superGrammar, IndexedVector rules) {
        this.name = name;
        this.superGrammar = superGrammar;
        this.rules = rules;
        this.antlrTool = tool;
    }

    public void addOption(Option o) {
        if (this.options == null) {
            this.options = new IndexedVector();
        }
        this.options.appendElement(o.getName(), o);
    }

    public void addRule(Rule r) {
        this.rules.appendElement(r.getName(), r);
    }

    public void expandInPlace() {
        if (this.alreadyExpanded) {
            return;
        }
        Grammar superG = this.getSuperGrammar();
        if (superG == null) {
            return;
        }
        if (this.exportVocab == null) {
            this.exportVocab = this.getName();
        }
        if (superG.isPredefined()) {
            return;
        }
        superG.expandInPlace();
        this.alreadyExpanded = true;
        GrammarFile gf = this.hier.getFile(this.getFileName());
        gf.setExpanded(true);
        IndexedVector inhRules = superG.getRules();
        Enumeration e = inhRules.elements();
        while (e.hasMoreElements()) {
            Rule r = (Rule)e.nextElement();
            this.inherit(r, superG);
        }
        IndexedVector inhOptions = superG.getOptions();
        if (inhOptions != null) {
            Enumeration e2 = inhOptions.elements();
            while (e2.hasMoreElements()) {
                Option o = (Option)e2.nextElement();
                this.inherit(o, superG);
            }
        }
        if (this.options != null && this.options.getElement("importVocab") == null || this.options == null) {
            Option inputV = new Option("importVocab", superG.exportVocab + ";", this);
            this.addOption(inputV);
            String originatingGrFileName = superG.getFileName();
            String path = this.antlrTool.pathToFile(originatingGrFileName);
            String superExportVocabFileName = path + superG.exportVocab + CodeGenerator.TokenTypesFileSuffix + CodeGenerator.TokenTypesFileExt;
            String newImportVocabFileName = this.antlrTool.fileMinusPath(superExportVocabFileName);
            if (!path.equals("." + System.getProperty("file.separator"))) {
                try {
                    this.antlrTool.copyFile(superExportVocabFileName, newImportVocabFileName);
                }
                catch (IOException io) {
                    this.antlrTool.toolError("cannot find/copy importVocab file " + superExportVocabFileName);
                    return;
                }
            }
        }
        this.inherit(superG.memberAction, superG);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.name;
    }

    public IndexedVector getOptions() {
        return this.options;
    }

    public IndexedVector getRules() {
        return this.rules;
    }

    public Grammar getSuperGrammar() {
        if (this.superGrammar == null) {
            return null;
        }
        Grammar g = this.hier.getGrammar(this.superGrammar);
        return g;
    }

    public String getSuperGrammarName() {
        return this.superGrammar;
    }

    public String getType() {
        return this.type;
    }

    public void inherit(Option o, Grammar superG) {
        if (o.getName().equals("importVocab") || o.getName().equals("exportVocab")) {
            return;
        }
        Option overriddenOption = null;
        if (this.options != null) {
            overriddenOption = (Option)this.options.getElement(o.getName());
        }
        if (overriddenOption == null) {
            this.addOption(o);
        }
    }

    public void inherit(Rule r, Grammar superG) {
        Rule overriddenRule = (Rule)this.rules.getElement(r.getName());
        if (overriddenRule != null) {
            if (!overriddenRule.sameSignature(r)) {
                this.antlrTool.warning("rule " + this.getName() + "." + overriddenRule.getName() + " has different signature than " + superG.getName() + "." + overriddenRule.getName());
            }
        } else {
            this.addRule(r);
        }
    }

    public void inherit(String memberAction, Grammar superG) {
        if (this.memberAction != null) {
            return;
        }
        if (memberAction != null) {
            this.memberAction = memberAction;
        }
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public void setFileName(String f) {
        this.fileName = f;
    }

    public void setHierarchy(Hierarchy hier) {
        this.hier = hier;
    }

    public void setMemberAction(String a) {
        this.memberAction = a;
    }

    public void setOptions(IndexedVector options) {
        this.options = options;
    }

    public void setPreambleAction(String a) {
        this.preambleAction = a;
    }

    public void setPredefined(boolean b) {
        this.predefined = b;
    }

    public void setTokenSection(String tk) {
        this.tokenSection = tk;
    }

    public void setType(String t) {
        this.type = t;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(10000);
        if (this.preambleAction != null) {
            s.append(this.preambleAction);
        }
        if (this.superGrammar == null) {
            return "class " + this.name + ";";
        }
        if (this.superClass != null) {
            s.append("class " + this.name + " extends " + this.superClass + ";");
        } else {
            s.append("class " + this.name + " extends " + this.type + ";");
        }
        s.append(System.getProperty("line.separator") + System.getProperty("line.separator"));
        if (this.options != null) {
            s.append(Hierarchy.optionsToString(this.options));
        }
        if (this.tokenSection != null) {
            s.append(this.tokenSection + "\n");
        }
        if (this.memberAction != null) {
            s.append(this.memberAction + System.getProperty("line.separator"));
        }
        for (int i = 0; i < this.rules.size(); ++i) {
            Rule r = (Rule)this.rules.elementAt(i);
            if (!this.getName().equals(r.enclosingGrammar.getName())) {
                s.append("// inherited from grammar " + r.enclosingGrammar.getName() + System.getProperty("line.separator"));
            }
            s.append(r + System.getProperty("line.separator") + System.getProperty("line.separator"));
        }
        return s.toString();
    }
}

