/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTenantDatabaseRequest extends RdsRequest implements
        ToCopyableBuilder<DeleteTenantDatabaseRequest.Builder, DeleteTenantDatabaseRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(DeleteTenantDatabaseRequest::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> TENANT_DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantDBName").getter(getter(DeleteTenantDatabaseRequest::tenantDBName))
            .setter(setter(Builder::tenantDBName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDBName").build()).build();

    private static final SdkField<Boolean> SKIP_FINAL_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SkipFinalSnapshot").getter(getter(DeleteTenantDatabaseRequest::skipFinalSnapshot))
            .setter(setter(Builder::skipFinalSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipFinalSnapshot").build()).build();

    private static final SdkField<String> FINAL_DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FinalDBSnapshotIdentifier").getter(getter(DeleteTenantDatabaseRequest::finalDBSnapshotIdentifier))
            .setter(setter(Builder::finalDBSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalDBSnapshotIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD,
            TENANT_DB_NAME_FIELD, SKIP_FINAL_SNAPSHOT_FIELD, FINAL_DB_SNAPSHOT_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbInstanceIdentifier;

    private final String tenantDBName;

    private final Boolean skipFinalSnapshot;

    private final String finalDBSnapshotIdentifier;

    private DeleteTenantDatabaseRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.tenantDBName = builder.tenantDBName;
        this.skipFinalSnapshot = builder.skipFinalSnapshot;
        this.finalDBSnapshotIdentifier = builder.finalDBSnapshotIdentifier;
    }

    /**
     * <p>
     * The user-supplied identifier for the DB instance that contains the tenant database that you want to delete.
     * </p>
     * 
     * @return The user-supplied identifier for the DB instance that contains the tenant database that you want to
     *         delete.
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * The user-supplied name of the tenant database that you want to remove from your DB instance. Amazon RDS deletes
     * the tenant database with this name. This parameter isn’t case-sensitive.
     * </p>
     * 
     * @return The user-supplied name of the tenant database that you want to remove from your DB instance. Amazon RDS
     *         deletes the tenant database with this name. This parameter isn’t case-sensitive.
     */
    public final String tenantDBName() {
        return tenantDBName;
    }

    /**
     * <p>
     * Specifies whether to skip the creation of a final DB snapshot before removing the tenant database from your DB
     * instance. If you enable this parameter, RDS doesn't create a DB snapshot. If you don't enable this parameter, RDS
     * creates a DB snapshot before it deletes the tenant database. By default, RDS doesn't skip the final snapshot. If
     * you don't enable this parameter, you must specify the <code>FinalDBSnapshotIdentifier</code> parameter.
     * </p>
     * 
     * @return Specifies whether to skip the creation of a final DB snapshot before removing the tenant database from
     *         your DB instance. If you enable this parameter, RDS doesn't create a DB snapshot. If you don't enable
     *         this parameter, RDS creates a DB snapshot before it deletes the tenant database. By default, RDS doesn't
     *         skip the final snapshot. If you don't enable this parameter, you must specify the
     *         <code>FinalDBSnapshotIdentifier</code> parameter.
     */
    public final Boolean skipFinalSnapshot() {
        return skipFinalSnapshot;
    }

    /**
     * <p>
     * The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the
     * <code>SkipFinalSnapshot</code> parameter is disabled.
     * </p>
     * <note>
     * <p>
     * If you enable this parameter and also enable <code>SkipFinalShapshot</code>, the command results in an error.
     * </p>
     * </note>
     * 
     * @return The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the
     *         <code>SkipFinalSnapshot</code> parameter is disabled.</p> <note>
     *         <p>
     *         If you enable this parameter and also enable <code>SkipFinalShapshot</code>, the command results in an
     *         error.
     *         </p>
     */
    public final String finalDBSnapshotIdentifier() {
        return finalDBSnapshotIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(tenantDBName());
        hashCode = 31 * hashCode + Objects.hashCode(skipFinalSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(finalDBSnapshotIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTenantDatabaseRequest)) {
            return false;
        }
        DeleteTenantDatabaseRequest other = (DeleteTenantDatabaseRequest) obj;
        return Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(tenantDBName(), other.tenantDBName())
                && Objects.equals(skipFinalSnapshot(), other.skipFinalSnapshot())
                && Objects.equals(finalDBSnapshotIdentifier(), other.finalDBSnapshotIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTenantDatabaseRequest").add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("TenantDBName", tenantDBName()).add("SkipFinalSnapshot", skipFinalSnapshot())
                .add("FinalDBSnapshotIdentifier", finalDBSnapshotIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "TenantDBName":
            return Optional.ofNullable(clazz.cast(tenantDBName()));
        case "SkipFinalSnapshot":
            return Optional.ofNullable(clazz.cast(skipFinalSnapshot()));
        case "FinalDBSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(finalDBSnapshotIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("TenantDBName", TENANT_DB_NAME_FIELD);
        map.put("SkipFinalSnapshot", SKIP_FINAL_SNAPSHOT_FIELD);
        map.put("FinalDBSnapshotIdentifier", FINAL_DB_SNAPSHOT_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteTenantDatabaseRequest, T> g) {
        return obj -> g.apply((DeleteTenantDatabaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteTenantDatabaseRequest> {
        /**
         * <p>
         * The user-supplied identifier for the DB instance that contains the tenant database that you want to delete.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        The user-supplied identifier for the DB instance that contains the tenant database that you want to
         *        delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * The user-supplied name of the tenant database that you want to remove from your DB instance. Amazon RDS
         * deletes the tenant database with this name. This parameter isn’t case-sensitive.
         * </p>
         * 
         * @param tenantDBName
         *        The user-supplied name of the tenant database that you want to remove from your DB instance. Amazon
         *        RDS deletes the tenant database with this name. This parameter isn’t case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantDBName(String tenantDBName);

        /**
         * <p>
         * Specifies whether to skip the creation of a final DB snapshot before removing the tenant database from your
         * DB instance. If you enable this parameter, RDS doesn't create a DB snapshot. If you don't enable this
         * parameter, RDS creates a DB snapshot before it deletes the tenant database. By default, RDS doesn't skip the
         * final snapshot. If you don't enable this parameter, you must specify the
         * <code>FinalDBSnapshotIdentifier</code> parameter.
         * </p>
         * 
         * @param skipFinalSnapshot
         *        Specifies whether to skip the creation of a final DB snapshot before removing the tenant database from
         *        your DB instance. If you enable this parameter, RDS doesn't create a DB snapshot. If you don't enable
         *        this parameter, RDS creates a DB snapshot before it deletes the tenant database. By default, RDS
         *        doesn't skip the final snapshot. If you don't enable this parameter, you must specify the
         *        <code>FinalDBSnapshotIdentifier</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipFinalSnapshot(Boolean skipFinalSnapshot);

        /**
         * <p>
         * The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the
         * <code>SkipFinalSnapshot</code> parameter is disabled.
         * </p>
         * <note>
         * <p>
         * If you enable this parameter and also enable <code>SkipFinalShapshot</code>, the command results in an error.
         * </p>
         * </note>
         * 
         * @param finalDBSnapshotIdentifier
         *        The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the
         *        <code>SkipFinalSnapshot</code> parameter is disabled.</p> <note>
         *        <p>
         *        If you enable this parameter and also enable <code>SkipFinalShapshot</code>, the command results in an
         *        error.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalDBSnapshotIdentifier(String finalDBSnapshotIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbInstanceIdentifier;

        private String tenantDBName;

        private Boolean skipFinalSnapshot;

        private String finalDBSnapshotIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTenantDatabaseRequest model) {
            super(model);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            tenantDBName(model.tenantDBName);
            skipFinalSnapshot(model.skipFinalSnapshot);
            finalDBSnapshotIdentifier(model.finalDBSnapshotIdentifier);
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getTenantDBName() {
            return tenantDBName;
        }

        public final void setTenantDBName(String tenantDBName) {
            this.tenantDBName = tenantDBName;
        }

        @Override
        public final Builder tenantDBName(String tenantDBName) {
            this.tenantDBName = tenantDBName;
            return this;
        }

        public final Boolean getSkipFinalSnapshot() {
            return skipFinalSnapshot;
        }

        public final void setSkipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
        }

        @Override
        public final Builder skipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
            return this;
        }

        public final String getFinalDBSnapshotIdentifier() {
            return finalDBSnapshotIdentifier;
        }

        public final void setFinalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
        }

        @Override
        public final Builder finalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTenantDatabaseRequest build() {
            return new DeleteTenantDatabaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
