/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support;

import org.apache.commons.lang3.Validate;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import ro.isdc.wro.util.ObjectFactory;

public class ObjectPoolHelper<T> {
    private static final int MAX_IDLE = 2;
    private static final long MAX_WAIT = 5000L;
    private static final long EVICTABLE_IDLE_TIME = 30000L;
    private GenericObjectPool<T> objectPool;

    public ObjectPoolHelper(ObjectFactory<T> objectFactory) {
        Validate.notNull(objectFactory);
        this.objectPool = this.createObjectPool(objectFactory);
        Validate.notNull(this.objectPool);
    }

    private GenericObjectPool<T> createObjectPool(ObjectFactory<T> objectFactory) {
        GenericObjectPool<T> pool = this.newObjectPool(objectFactory);
        Validate.notNull(pool);
        return pool;
    }

    protected GenericObjectPool<T> newObjectPool(final ObjectFactory<T> objectFactory) {
        int maxActive = Math.max(2, Runtime.getRuntime().availableProcessors());
        GenericObjectPool pool = new GenericObjectPool((PoolableObjectFactory)new BasePoolableObjectFactory<T>(){

            public T makeObject() throws Exception {
                return objectFactory.create();
            }
        });
        pool.setMaxActive(maxActive);
        pool.setMaxIdle(2);
        pool.setMaxWait(5000L);
        pool.setWhenExhaustedAction((byte)2);
        pool.setSoftMinEvictableIdleTimeMillis(30000L);
        pool.setTimeBetweenEvictionRunsMillis(30000L);
        return pool;
    }

    public T getObject() {
        try {
            return (T)this.objectPool.borrowObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get object from the pool", e);
        }
    }

    public void returnObject(T engine) {
        Validate.notNull(engine);
        try {
            this.objectPool.returnObject(engine);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get object from the pool", e);
        }
    }

    public final void setObjectPool(GenericObjectPool<T> objectPool) {
        Validate.notNull(objectPool);
        this.objectPool = objectPool;
    }
}

