/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.script;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RhinoUtils {
    private static Pattern[] ESCAPE_PATTERNS = new Pattern[]{Pattern.compile("\\\\"), Pattern.compile("\\n"), Pattern.compile("\\r"), Pattern.compile("\\t"), Pattern.compile("\\f"), Pattern.compile("\\\"")};
    private static String[] ESCAPE_REPLACEMENTS = new String[]{Matcher.quoteReplacement("\\\\"), Matcher.quoteReplacement("\\n"), Matcher.quoteReplacement("\\r"), Matcher.quoteReplacement("\\t"), Matcher.quoteReplacement("\\f"), Matcher.quoteReplacement("\\\"")};

    public static String createExceptionMessage(RhinoException e) {
        String message = "Could not execute the script because: ";
        if (e instanceof JavaScriptException) {
            message = message + RhinoUtils.toJson(((JavaScriptException)((Object)e)).getValue());
        } else if (e instanceof EcmaError) {
            EcmaError ecmaError = (EcmaError)e;
            message = message + String.format("Error message: %s at line: %s. \nSource: %s", ecmaError.getErrorMessage(), ecmaError.lineNumber(), ecmaError.lineSource());
        } else {
            message = message + e.getMessage();
        }
        return message;
    }

    public static String toJson(Object object) {
        return RhinoUtils.toJson(object, false);
    }

    public static String toJson(Object object, boolean indent) {
        StringBuilder s = new StringBuilder();
        RhinoUtils.encode(s, object, indent, indent ? 0 : -1);
        return s.toString();
    }

    private static void encode(StringBuilder s, Object object, boolean indent, int depth) {
        if (indent) {
            RhinoUtils.indent(s, depth);
        }
        if (object == null) {
            s.append("null");
        } else if (object instanceof Number) {
            s.append(object);
        } else if (object instanceof Boolean) {
            s.append(object);
        } else if (object instanceof Date) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("$date", ((Date)object).getTime());
            RhinoUtils.encode(s, map, depth);
        } else if (object instanceof Collection) {
            RhinoUtils.encode(s, (Collection)object, depth);
        } else if (object instanceof Map) {
            RhinoUtils.encode(s, (Map)object, depth);
        } else if (object instanceof ScriptableObject) {
            Object time;
            ScriptableObject scriptable = (ScriptableObject)object;
            if (scriptable.getClassName().equals("Date") && (time = ScriptableObject.callMethod((Scriptable)scriptable, (String)"getTime", null)) instanceof Number) {
                RhinoUtils.encode(s, new Date(((Number)time).longValue()), false, depth);
                return;
            }
            RhinoUtils.encode(s, scriptable, depth);
        } else {
            s.append('\"');
            s.append(RhinoUtils.escape(object.toString()));
            s.append('\"');
        }
    }

    private static void encode(StringBuilder s, Collection<?> collection, int depth) {
        s.append('[');
        Iterator<?> i = collection.iterator();
        if (i.hasNext()) {
            if (depth > -1) {
                s.append('\n');
            }
            while (true) {
                Object value = i.next();
                RhinoUtils.encode(s, value, true, depth > -1 ? depth + 1 : -1);
                if (!i.hasNext()) break;
                s.append(',');
                if (depth <= -1) continue;
                s.append('\n');
            }
            if (depth > -1) {
                s.append('\n');
            }
        }
        if (depth > -1) {
            RhinoUtils.indent(s, depth);
        }
        s.append(']');
    }

    private static void encode(StringBuilder s, Map<?, ?> map, int depth) {
        s.append('{');
        Iterator<Map.Entry<?, ?>> i = map.entrySet().iterator();
        if (i.hasNext()) {
            if (depth > -1) {
                s.append('\n');
            }
            while (true) {
                Map.Entry<?, ?> entry = i.next();
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                if (depth > -1) {
                    RhinoUtils.indent(s, depth + 1);
                }
                s.append('\"');
                s.append(RhinoUtils.escape(key));
                s.append("\":");
                if (depth > -1) {
                    s.append(' ');
                }
                RhinoUtils.encode(s, value, false, depth > -1 ? depth + 1 : -1);
                if (!i.hasNext()) break;
                s.append(',');
                if (depth <= -1) continue;
                s.append('\n');
            }
            if (depth > -1) {
                s.append('\n');
            }
        }
        if (depth > -1) {
            RhinoUtils.indent(s, depth);
        }
        s.append('}');
    }

    private static void encode(StringBuilder s, NativeArray array, int depth) {
        s.append('[');
        long length = array.getLength();
        if (length > 0L) {
            if (depth > -1) {
                s.append('\n');
            }
            int i = 0;
            while ((long)i < length) {
                Object value = ScriptableObject.getProperty((Scriptable)array, (int)i);
                RhinoUtils.encode(s, value, true, depth > -1 ? depth + 1 : -1);
                if ((long)i < length - 1L) {
                    s.append(',');
                    if (depth > -1) {
                        s.append('\n');
                    }
                }
                ++i;
            }
            if (depth > -1) {
                s.append('\n');
            }
        }
        if (depth > -1) {
            RhinoUtils.indent(s, depth);
        }
        s.append(']');
    }

    private static void encode(StringBuilder s, ScriptableObject object, int depth) {
        s.append('{');
        Object[] ids = object.getAllIds();
        if (ids.length > 0) {
            if (depth > -1) {
                s.append('\n');
            }
            int length = ids.length;
            for (int i = 0; i < length; ++i) {
                String key = ids[i].toString();
                Object value = ScriptableObject.getProperty((Scriptable)object, (String)key);
                if (depth > -1) {
                    RhinoUtils.indent(s, depth + 1);
                }
                s.append('\"');
                s.append(RhinoUtils.escape(key));
                s.append("\":");
                if (depth > -1) {
                    s.append(' ');
                }
                RhinoUtils.encode(s, value, false, depth > -1 ? depth + 1 : -1);
                if (i >= length - 1) continue;
                s.append(',');
                if (depth <= -1) continue;
                s.append('\n');
            }
            if (depth > -1) {
                s.append('\n');
            }
        }
        if (depth > -1) {
            RhinoUtils.indent(s, depth);
        }
        s.append('}');
    }

    private static void indent(StringBuilder s, int depth) {
        for (int i = depth - 1; i >= 0; --i) {
            s.append("  ");
        }
    }

    private static String escape(String string) {
        int length = ESCAPE_PATTERNS.length;
        for (int i = 0; i < length; ++i) {
            string = ESCAPE_PATTERNS[i].matcher(string).replaceAll(ESCAPE_REPLACEMENTS[i]);
        }
        return string;
    }
}

