/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsf.zul.impl;

import java.text.SimpleDateFormat;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.zkoss.jsf.zul.impl.BranchInput;
import org.zkoss.jsf.zul.impl.FormateHolder;
import org.zkoss.zk.ui.Component;

public abstract class BaseTimebox
extends BranchInput {
    protected void afterZULComponentComposed(Component zulcomp) {
        Converter converter = this.getConverter();
        if (converter == null) {
            converter = new TimeFormatConverter("HH:mm");
            this.setConverter(converter);
        }
        super.afterZULComponentComposed(zulcomp);
    }

    public String getMappedAttributeName() {
        return "text";
    }

    public static class TimeFormatConverter
    extends FormateHolder
    implements Converter {
        private SimpleDateFormat _formater;

        public TimeFormatConverter() {
            this.formatChanged();
        }

        public TimeFormatConverter(String format) {
            super(format);
            this.formatChanged();
        }

        protected void formatChanged() {
            if (this._formater == null) {
                this._formater = new SimpleDateFormat();
            }
            if (this._format == null) {
                this._formater.applyLocalizedPattern("HH:mm");
            } else {
                this._formater.applyLocalizedPattern(this._format);
            }
        }

        public Object getAsObject(FacesContext context, UIComponent component, String value) {
            try {
                if (value == null || "".equals(value.trim())) {
                    return null;
                }
                return this._formater.parse(value);
            }
            catch (Exception e) {
                throw new ConverterException(e.getMessage());
            }
        }

        public String getAsString(FacesContext context, UIComponent component, Object value) {
            if (value == null) {
                return null;
            }
            try {
                return this._formater.format(value);
            }
            catch (Exception e) {
                throw new ConverterException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

