/* Utils.java

{{IS_NOTE
	Purpose:
		
	Description:
		
	History:
		Fri Jul 20 19:30:17     2007, Created by Dennis.Chen
}}IS_NOTE

Copyright (C) 2007 Potix Corporation. All Rights Reserved.

{{IS_RIGHT
	This program is distributed under GPL Version 2.0 in the hope that
	it will be useful, but WITHOUT ANY WARRANTY.
}}IS_RIGHT
*/
package org.zkoss.jsf.zul.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.ArrayList;
import java.io.Writer;
import java.io.IOException;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import org.zkoss.lang.Objects;

import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Component;


/**
 * A utility to be shared by {@link BranchComponent} and {@link RootComponent} to
 * implement the capability to hold a list of children.
 *
 * @author Dennis.Chen
 */
/*package*/ class Utils {
	private static final String MARK_PREFIX = "<zk~f[", MARK_POSTFIX = "]>";

	/** Adjust the children based the output generated by the inner
	 * components of {@link BranchComponent} (aka., body).
	 *
	 * @param page the page. Specified ony if parent is null (aka. root).
	 * @param parent the parent component. If null, page must be specified.
	 */
	/*package*/ static void adjustChildren(Page page, AbstractComponent parent,
	Collection children, String body) {

		Iterator it = new ArrayList(children).iterator();
		
		//component info for current JSFZUL component tree.
		ComponentInfo cinfo = parent.getComponentInfo();

		for (int j = 0, len = body != null ? body.length(): 0; j < len;) {
			int k = body.indexOf(MARK_PREFIX, j);
			String txt =  null;
			LeafComponent child = null;
			if (k >= 0) {
				int l = k + MARK_PREFIX.length();
				int m = body.indexOf(MARK_POSTFIX, l);
				if (m <= l) { //not found or empty uuid
					k = -1;
				} else {
					txt = body.substring(j, k).trim();
					child = matchNextLeafComponent(it,(AbstractComponent)cinfo.getRegistedComponent(body.substring(l, m)));
					k = m + MARK_POSTFIX.length();
				}
			}
			if (k < 0)
				txt = body.substring(j).trim();
			//inline handle...
			if (txt.length() > 0) {
				final Inline inl = new Inline(txt);
				if (child != null) {
					if (parent != null && parent instanceof LeafComponent)
						((LeafComponent)parent).getZULComponent().insertBefore(inl, child.getZULComponent());
					else
						inl.setPageBefore(page, child.getZULComponent());
				} else {
					if (parent != null && parent instanceof LeafComponent)
						((LeafComponent)parent).getZULComponent().appendChild(inl);
					else
						inl.setPage(page);
				}
			}

			if (k < 0) break; //no more
			j = k;
		}

//		while (it.hasNext())
//			((Component)it.next()).detach();
	}
	
	/** Matches the next component with the specified child,
	 * returns null if no match at all.
	 * Note: if it.next().getUuid() is not uuid, it will be removed.
	 */
	private static LeafComponent matchNextLeafComponent(Iterator it, AbstractComponent child) {
		while (it.hasNext()) {
			final AbstractComponent nextchild = (AbstractComponent)it.next();
			if(! (nextchild instanceof LeafComponent)){
				//not a LeafComponent, maybe a ZScript or other, so do not adjuest it
				continue;
			}
			
			if (Objects.equals(nextchild, child)){
				return (LeafComponent)nextchild; //found
			}
			/**
			 * remove components that not in same order, 
			 */
			Component comp  = ((LeafComponent)nextchild).getZULComponent();
			if(comp!=null){
				comp.detach(); //remove it
			}

		}
		return null;
	}
	/** Writes a special mark to the output to represent the component
	 * of the specified child.
	 * The mark is then used by {@link #adjustChildren}
	 */
	/*package*/ static void writeComponentMark(Writer out, AbstractComponent comp)
	throws IOException {
		String uid = comp.getComponentInfo().registerComponent(comp);
		out.write(MARK_PREFIX);
		out.write(uid);
		out.write(MARK_POSTFIX);
	}
	
	/**
	 * a helper for render a component, It's will go thought a component.
	 * @param component the component to render
	 * @param context the FacesContext.
	 * @throws IOException
	 */
	/*package*/ static void renderComponent(UIComponent component,
            FacesContext context) throws IOException {
        if (!component.isRendered())
            return;
        
        if(component instanceof AbstractComponent){
        	if(!((AbstractComponent)component).isEffective()){
        		return;
        	}
        }
        
        //String id = component.getId();
        //if (id != null) component.setId(id);
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            UIComponent kid;
            for (Iterator kids = component.getChildren().iterator(); kids
                    .hasNext(); renderComponent(kid, context))
                kid = (UIComponent) kids.next();

        }
        component.encodeEnd(context);
    }

}
