/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Set;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Row;

class GridDrawerEngine
implements Serializable,
Cloneable {
    private Grid _grid;
    private int _curpos;
    private int _extent;
    private transient EventListener _scrollListener;

    GridDrawerEngine(Grid grid) {
        this._grid = grid;
        this.initDataListener();
    }

    private void initDataListener() {
        if (this._scrollListener == null) {
            this._scrollListener = new EventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onEvent(Event event) {
                    if (GridDrawerEngine.this._grid.getRows() != null && GridDrawerEngine.this._grid.getModel() != null && GridDrawerEngine.this._grid.inSpecialMold()) {
                        String[] data = ((String)event.getData()).split(",");
                        GridDrawerEngine.this._curpos = Integer.parseInt(data[0]);
                        GridDrawerEngine.this._extent = Integer.parseInt(data[1]);
                        if (GridDrawerEngine.this._grid.getColumns() != null) {
                            GridDrawerEngine.this._grid.setInnerWidth(data[2]);
                        }
                        GridDrawerEngine.this._grid.setInnerHeight(data[3]);
                        GridDrawerEngine.this._grid.setInnerTop(data[4]);
                        GridDrawerEngine.this._grid.setInnerBottom(data[5]);
                        int pgsz = GridDrawerEngine.this.getRenderAmount();
                        Grid.Renderer renderer = GridDrawerEngine.this._grid.new Grid.Renderer();
                        try {
                            ListIterator it = GridDrawerEngine.this._grid.getRows().getChildren().listIterator(GridDrawerEngine.this.getRenderBegin());
                            while (--pgsz >= 0 && it.hasNext()) {
                                renderer.render((Row)it.next());
                            }
                        }
                        catch (Throwable ex) {
                            renderer.doCatch(ex);
                        }
                        finally {
                            renderer.doFinally();
                        }
                    }
                    if (GridDrawerEngine.this._grid.getRows() != null) {
                        GridDrawerEngine.this._grid.getRows().invalidate();
                    }
                }
            };
        }
        this._grid.addEventListener("onRenderAtScroll", this._scrollListener);
    }

    Set getAvailableAtClient() {
        if (!this._grid.inSpecialMold()) {
            return null;
        }
        LinkedHashSet avail = new LinkedHashSet(32);
        avail.addAll(this._grid.getHeads());
        int pgsz = this.getRenderAmount();
        int ofs = this.getRenderBegin();
        ListIterator it = this._grid.getRows().getChildren().listIterator(ofs);
        while (--pgsz >= 0 && it.hasNext()) {
            avail.add(it.next());
        }
        return avail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onInitRender() {
        Grid.Renderer renderer = this._grid.new Grid.Renderer();
        try {
            int pgsz = this.getRenderAmount();
            int ofs = this.getRenderBegin();
            ListIterator it = this._grid.getRows().getChildren().listIterator(ofs);
            for (int j = 0; j < pgsz && it.hasNext(); ++j) {
                renderer.render((Row)it.next());
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    int getRenderBegin() {
        int begin = this.getCurpos() - this._grid.getPreloadSize();
        if (begin < 0) {
            begin = 0;
        }
        return begin;
    }

    Iterator getVisibleChildrenIterator() {
        return this._grid.getRows() != null ? new VisibleChildrenIterator() : Collections.EMPTY_LIST.iterator();
    }

    int getCurpos() {
        return this._curpos;
    }

    int getRenderEnd() {
        return this.getRenderAmount() + this.getRenderBegin() - 1;
    }

    int getRenderAmount() {
        if (this.getCurpos() - this._grid.getPreloadSize() >= 0) {
            return this._extent + this._grid.getPreloadSize() * 2;
        }
        return this._extent + this._grid.getPreloadSize() + this.getCurpos();
    }

    int getMaxpos() {
        return this._grid.getRows().getChildren().size() - this.getVisibleAmount();
    }

    int getVisibleAmount() {
        return this._extent;
    }

    public Object clone() {
        GridDrawerEngine clone;
        try {
            clone = (GridDrawerEngine)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._scrollListener = null;
        clone.initDataListener();
        return clone;
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.initDataListener();
    }

    private class VisibleChildrenIterator
    implements Iterator {
        private ListIterator _it;
        private int _end;
        private int _count;

        private VisibleChildrenIterator() {
            this._it = GridDrawerEngine.this._grid.getRows().getChildren().listIterator(GridDrawerEngine.this.getRenderBegin());
            this._end = GridDrawerEngine.this.getRenderEnd();
        }

        public boolean hasNext() {
            return this._count < this._end;
        }

        public Object next() {
            ++this._count;
            return this._it.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

