/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zhtml.impl;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.zkoss.zhtml.impl.RenderContext;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zk.ui.sys.PageCtrl;

public class PageRenderer
implements org.zkoss.zk.ui.sys.PageRenderer {
    private static final String ATTR_RENDER_CONTEXT = "org.zkoss.zhtml.renderContext";

    public static boolean isDirectContent(Execution exec) {
        if (exec == null && (exec = Executions.getCurrent()) == null) {
            return false;
        }
        RenderContext rc = PageRenderer.getRenderContext(exec);
        return rc != null && rc.directContent;
    }

    public static RenderContext getRenderContext(Execution exec) {
        if (exec == null) {
            exec = Executions.getCurrent();
        }
        return exec != null ? (RenderContext)exec.getAttribute(ATTR_RENDER_CONTEXT) : null;
    }

    public void render(Page page, Writer out) throws IOException {
        Execution exec = Executions.getCurrent();
        String ctl = (String)exec.getAttribute("org.zkoss.zk.ui.page.redrawCtrl");
        boolean au = exec.isAsyncUpdate(null);
        if (!au && (page.isComplete() || "complete".equals(ctl))) {
            this.renderComplete(exec, page, out);
            return;
        }
        boolean pageOnly = au;
        if (!pageOnly) {
            boolean bl = pageOnly = (exec.isIncluded() || "page".equals(ctl)) && !"desktop".equals(ctl);
        }
        if (pageOnly) {
            this.renderPage(exec, page, out, au);
        } else {
            exec.setAttribute("org.zkoss.zk.ui.page.redrawCtrl", (Object)"complete");
            this.renderComplete(exec, page, out);
        }
    }

    private static void write(Writer out, String s) throws IOException {
        if (s != null) {
            out.write(s);
        }
    }

    private static void writeln(Writer out, String s) throws IOException {
        if (s != null) {
            out.write(s);
            out.write(10);
        }
    }

    protected void renderPage(Execution exec, Page page, Writer out, boolean au) throws IOException {
        if (!au) {
            out.write(HtmlPageRenders.outLangStyleSheets((Execution)exec, null, null));
            out.write(HtmlPageRenders.outLangJavaScripts((Execution)exec, null, null));
        }
        HtmlPageRenders.outPageContent((Execution)exec, (Page)page, (Writer)out, (boolean)au);
        if (!au && ((PageCtrl)page).getOwner() == null) {
            PageRenderer.writeln(out, HtmlPageRenders.outUnavailable((Execution)exec));
        }
        out.write(HtmlPageRenders.outResponseJavaScripts((Execution)exec));
    }

    protected void renderComplete(Execution exec, Page page, Writer out) throws IOException {
        RenderContext rc = new RenderContext();
        exec.setAttribute(ATTR_RENDER_CONTEXT, (Object)rc);
        HtmlPageRenders.setContentType((Execution)exec, (Page)page);
        Iterator it = page.getRoots().iterator();
        while (it.hasNext()) {
            ((ComponentCtrl)it.next()).redraw(out);
        }
        String rcs = rc.complete();
        if (rcs.length() > 0) {
            if (out instanceof StringWriter) {
                StringBuffer buf = ((StringWriter)out).getBuffer();
                int j = buf.lastIndexOf("</body>");
                if (j >= 0) {
                    buf.insert(j, rcs);
                } else {
                    buf.append(rcs);
                }
            } else {
                out.write(rcs);
            }
        }
        PageRenderer.write(out, HtmlPageRenders.outZkTags((Execution)exec, (Desktop)page.getDesktop()));
        PageRenderer.writeln(out, HtmlPageRenders.outUnavailable((Execution)exec));
        exec.setAttribute(ATTR_RENDER_CONTEXT, null);
    }
}

