/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Arrays;
import javax.security.sasl.SaslException;

public interface SaslWrapper {
    public static final SaslWrapper IDENTITY = new SaslWrapper(){

        @Override
        public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
            if (offset == 0 && outgoing.length == len) {
                return outgoing;
            }
            return Arrays.copyOfRange(outgoing, offset, len);
        }

        @Override
        public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
            if (offset == 0 && incoming.length == len) {
                return incoming;
            }
            return Arrays.copyOfRange(incoming, offset, len);
        }
    };

    public byte[] wrap(byte[] var1, int var2, int var3) throws SaslException;

    public byte[] unwrap(byte[] var1, int var2, int var3) throws SaslException;
}

