/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.util.id;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.uncommons.util.id.IDSource;
import org.uncommons.util.id.IntSequenceIDSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeIDSource
implements IDSource<Long> {
    private final Lock lock = new ReentrantLock();
    private final long top32bits;
    private final IDSource<Integer> sequence = new IntSequenceIDSource();

    public CompositeIDSource(int topPart) {
        this.top32bits = (long)topPart << 32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long nextID() {
        this.lock.lock();
        try {
            Long l = this.top32bits + (long)this.sequence.nextID().intValue();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }
}

