/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.integration.jmx.IoServiceManager;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.MessageListener;
import org.subethamail.smtp.Version;
import org.subethamail.smtp.server.CommandHandler;
import org.subethamail.smtp.server.ConnectionHandler;
import org.subethamail.smtp.server.MessageListenerAdapter;
import org.subethamail.smtp.server.SMTPCodecDecoder;
import org.subethamail.smtp.server.SMTPCodecFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMTPServer {
    private static Logger log = LoggerFactory.getLogger(SMTPServer.class);
    public static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");
    private InetAddress bindAddress = null;
    private int port = 25;
    private String hostName;
    private int backlog = 5000;
    private MessageHandlerFactory messageHandlerFactory;
    private CommandHandler commandHandler;
    private SocketAcceptor acceptor;
    private ExecutorService executor;
    private ExecutorService acceptorThreadPool;
    private SocketAcceptorConfig config;
    private IoServiceManager serviceManager;
    private ObjectName jmxName;
    private ConnectionHandler handler;
    private SMTPCodecDecoder codecDecoder;
    private boolean go = false;
    private int maxConnections = 1000;
    private int connectionTimeout = 60000;
    private int maxRecipients = 1000;
    protected static final int DEFAULT_DATA_DEFERRED_SIZE = 0x400000;
    private int dataDeferredSize = 0x400000;
    private boolean announceTls = true;

    public SMTPServer(MessageHandlerFactory handlerFactory) {
        this.messageHandlerFactory = handlerFactory;
        try {
            this.hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            this.hostName = "localhost";
        }
        this.commandHandler = new CommandHandler();
        this.initService();
    }

    public SMTPServer(Collection<MessageListener> listeners) {
        this(new MessageListenerAdapter(listeners));
    }

    public void startJMXService() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.startJMXService(1000);
    }

    public void startJMXService(int pollingInterval) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.serviceManager.startCollectingStats(pollingInterval);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        mbs.registerMBean(this.serviceManager, this.jmxName);
    }

    public void stopJMXService() throws InstanceNotFoundException, MBeanRegistrationException {
        this.serviceManager.stopCollectingStats();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        mbs.unregisterMBean(this.jmxName);
    }

    private void initService() {
        try {
            ByteBuffer.setUseDirectBuffers((boolean)false);
            ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
            this.acceptorThreadPool = Executors.newCachedThreadPool();
            this.acceptor = new SocketAcceptor(Runtime.getRuntime().availableProcessors() + 1, (Executor)this.acceptorThreadPool);
            this.serviceManager = new IoServiceManager((IoService)this.acceptor);
            this.jmxName = new ObjectName("subethasmtp.mina.server:type=IoServiceManager");
            this.config = new SocketAcceptorConfig();
            this.config.setThreadModel(ThreadModel.MANUAL);
            this.config.setReuseAddress(true);
            DefaultIoFilterChainBuilder chain = this.config.getFilterChain();
            if (log.isTraceEnabled()) {
                chain.addLast("logger", (IoFilter)new LoggingFilter());
            }
            SMTPCodecFactory codecFactory = new SMTPCodecFactory(DEFAULT_CHARSET, this.getDataDeferredSize());
            this.codecDecoder = (SMTPCodecDecoder)codecFactory.getDecoder();
            chain.addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)codecFactory));
            this.executor = Executors.newCachedThreadPool(new ThreadFactory(){
                int sequence;

                public Thread newThread(Runnable r) {
                    ++this.sequence;
                    return new Thread(r, "SubEthaSMTP Thread " + this.sequence);
                }
            });
            chain.addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)this.executor));
            this.handler = new ConnectionHandler(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void start() {
        if (this.go) {
            throw new RuntimeException("SMTPServer is already started.");
        }
        InetSocketAddress isa = this.bindAddress == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.bindAddress, this.port);
        this.config.setBacklog(this.getBacklog());
        try {
            this.acceptor.bind((SocketAddress)isa, (IoHandler)this.handler, (IoServiceConfig)this.config);
            this.go = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        try {
            log.info("SMTP Server socket shut down.");
            try {
                this.acceptor.unbindAll();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.executor.shutdown();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.acceptorThreadPool.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.go = false;
        }
    }

    public void setAnnounceTLS(boolean announceTls) {
        this.announceTls = announceTls;
    }

    public boolean announceTLS() {
        return this.announceTls;
    }

    public String getHostName() {
        if (this.hostName == null) {
            return "localhost";
        }
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public synchronized boolean isRunning() {
        return this.go;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public String getName() {
        return "SubEthaSMTP";
    }

    public String getNameVersion() {
        return this.getName() + " " + Version.getSpecification();
    }

    public MessageHandlerFactory getMessageHandlerFactory() {
        return this.messageHandlerFactory;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public int getNumberOfConnections() {
        return this.handler.getNumberOfConnections();
    }

    public boolean hasTooManyConnections() {
        return this.maxConnections > -1 && this.getNumberOfConnections() >= this.maxConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxRecipients() {
        return this.maxRecipients;
    }

    public void setMaxRecipients(int maxRecipients) {
        this.maxRecipients = maxRecipients;
    }

    public int getDataDeferredSize() {
        return this.dataDeferredSize;
    }

    public void setDataDeferredSize(int dataDeferredSize) {
        if (this.isPowerOfTwo(dataDeferredSize)) {
            this.dataDeferredSize = dataDeferredSize;
            if (this.codecDecoder != null) {
                this.codecDecoder.setDataDeferredSize(dataDeferredSize);
            }
        } else {
            throw new IllegalArgumentException("Argument dataDeferredSize must be a positive power of two");
        }
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.handler.setReceiveBufferSize(receiveBufferSize);
    }

    protected boolean isPowerOfTwo(int x) {
        return x > 1 && (x & x - 1) == 0;
    }
}

