/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.CustomScopeConfigurer;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.http.converter.json.Jackson2ObjectMapperFactoryBean;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.SimpSessionScope;
import org.springframework.messaging.simp.annotation.support.SimpAnnotationMethodMessageHandler;
import org.springframework.messaging.simp.broker.SimpleBrokerMessageHandler;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;
import org.springframework.messaging.simp.user.DefaultUserDestinationResolver;
import org.springframework.messaging.simp.user.DefaultUserSessionRegistry;
import org.springframework.messaging.simp.user.UserDestinationMessageHandler;
import org.springframework.messaging.support.ExecutorSubscribableChannel;
import org.springframework.messaging.support.ImmutableMessageChannelInterceptor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.WebSocketMessageBrokerStats;
import org.springframework.web.socket.config.WebSocketNamespaceUtils;
import org.springframework.web.socket.handler.WebSocketHandlerDecoratorFactory;
import org.springframework.web.socket.messaging.StompSubProtocolHandler;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;
import org.springframework.web.socket.server.support.OriginHandshakeInterceptor;
import org.springframework.web.socket.server.support.WebSocketHttpRequestHandler;
import org.springframework.web.socket.sockjs.support.SockJsHttpRequestHandler;
import org.w3c.dom.Element;

class MessageBrokerBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String WEB_SOCKET_HANDLER_BEAN_NAME = "subProtocolWebSocketHandler";
    public static final String SOCKJS_SCHEDULER_BEAN_NAME = "messageBrokerSockJsScheduler";
    private static final int DEFAULT_MAPPING_ORDER = 1;
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)MessageBrokerBeanDefinitionParser.class.getClassLoader());

    MessageBrokerBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext context) {
        Object source = context.extractSource((Object)element);
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), source);
        context.pushContainingComponent(compDefinition);
        String orderAttribute = element.getAttribute("order");
        int order = orderAttribute.isEmpty() ? 1 : Integer.valueOf(orderAttribute);
        ManagedMap urlMap = new ManagedMap();
        urlMap.setSource(source);
        RootBeanDefinition handlerMappingDef = new RootBeanDefinition(SimpleUrlHandlerMapping.class);
        handlerMappingDef.getPropertyValues().add("order", (Object)order);
        handlerMappingDef.getPropertyValues().add("urlMap", (Object)urlMap);
        MessageBrokerBeanDefinitionParser.registerBeanDef(handlerMappingDef, context, source);
        Element channelElem = DomUtils.getChildElementByTagName((Element)element, (String)"client-inbound-channel");
        RuntimeBeanReference inChannel = this.getMessageChannel("clientInboundChannel", channelElem, context, source);
        channelElem = DomUtils.getChildElementByTagName((Element)element, (String)"client-outbound-channel");
        RuntimeBeanReference outChannel = this.getMessageChannel("clientOutboundChannel", channelElem, context, source);
        RootBeanDefinition registryBeanDef = new RootBeanDefinition(DefaultUserSessionRegistry.class);
        String registryBeanName = MessageBrokerBeanDefinitionParser.registerBeanDef(registryBeanDef, context, source);
        RuntimeBeanReference sessionRegistry = new RuntimeBeanReference(registryBeanName);
        RuntimeBeanReference subProtoHandler = this.registerSubProtoHandler(element, inChannel, outChannel, sessionRegistry, context, source);
        for (Element endpointElem : DomUtils.getChildElementsByTagName((Element)element, (String)"stomp-endpoint")) {
            RuntimeBeanReference requestHandler = this.registerRequestHandler(endpointElem, subProtoHandler, context, source);
            String pathAttribute = endpointElem.getAttribute("path");
            Assert.state((boolean)StringUtils.hasText((String)pathAttribute), (String)"Invalid <stomp-endpoint> (no path mapping)");
            List<String> paths = Arrays.asList(StringUtils.tokenizeToStringArray((String)pathAttribute, (String)","));
            for (String path : paths) {
                path = path.trim();
                Assert.state((boolean)StringUtils.hasText((String)path), (String)("Invalid <stomp-endpoint> path attribute: " + pathAttribute));
                if (DomUtils.getChildElementByTagName((Element)endpointElem, (String)"sockjs") != null) {
                    path = path.endsWith("/") ? path + "**" : path + "/**";
                }
                urlMap.put((Object)path, (Object)requestHandler);
            }
        }
        channelElem = DomUtils.getChildElementByTagName((Element)element, (String)"broker-channel");
        RuntimeBeanReference brokerChannel = this.getMessageChannel("brokerChannel", channelElem, context, source);
        RootBeanDefinition broker = this.registerMessageBroker(element, inChannel, outChannel, brokerChannel, context, source);
        RuntimeBeanReference converter = this.registerMessageConverter(element, context, source);
        RuntimeBeanReference template = this.registerMessagingTemplate(element, brokerChannel, converter, context, source);
        this.registerAnnotationMethodMessageHandler(element, inChannel, outChannel, converter, template, context, source);
        RuntimeBeanReference resolver = this.registerUserDestinationResolver(element, sessionRegistry, context, source);
        this.registerUserDestinationMessageHandler(inChannel, brokerChannel, resolver, context, source);
        Map<String, SimpSessionScope> scopeMap = Collections.singletonMap("websocket", new SimpSessionScope());
        RootBeanDefinition scopeConfigurer = new RootBeanDefinition(CustomScopeConfigurer.class);
        scopeConfigurer.getPropertyValues().add("scopes", scopeMap);
        MessageBrokerBeanDefinitionParser.registerBeanDefByName("webSocketScopeConfigurer", scopeConfigurer, context, source);
        this.registerWebSocketMessageBrokerStats(broker, inChannel, outChannel, context, source);
        context.popAndRegisterContainingComponent();
        return null;
    }

    private RuntimeBeanReference getMessageChannel(String name, Element element, ParserContext context, Object source) {
        RootBeanDefinition executor = null;
        if (element == null) {
            executor = this.getDefaultExecutorBeanDefinition(name);
        } else {
            Element executorElem = DomUtils.getChildElementByTagName((Element)element, (String)"executor");
            if (executorElem == null) {
                executor = this.getDefaultExecutorBeanDefinition(name);
            } else {
                executor = new RootBeanDefinition(ThreadPoolTaskExecutor.class);
                if (executorElem.hasAttribute("core-pool-size")) {
                    executor.getPropertyValues().add("corePoolSize", (Object)executorElem.getAttribute("core-pool-size"));
                }
                if (executorElem.hasAttribute("max-pool-size")) {
                    executor.getPropertyValues().add("maxPoolSize", (Object)executorElem.getAttribute("max-pool-size"));
                }
                if (executorElem.hasAttribute("keep-alive-seconds")) {
                    executor.getPropertyValues().add("keepAliveSeconds", (Object)executorElem.getAttribute("keep-alive-seconds"));
                }
                if (executorElem.hasAttribute("queue-capacity")) {
                    executor.getPropertyValues().add("queueCapacity", (Object)executorElem.getAttribute("queue-capacity"));
                }
            }
        }
        ConstructorArgumentValues argValues = new ConstructorArgumentValues();
        if (executor != null) {
            executor.getPropertyValues().add("threadNamePrefix", (Object)(name + "-"));
            String executorName = name + "Executor";
            MessageBrokerBeanDefinitionParser.registerBeanDefByName(executorName, executor, context, source);
            argValues.addIndexedArgumentValue(0, (Object)new RuntimeBeanReference(executorName));
        }
        RootBeanDefinition channelDef = new RootBeanDefinition(ExecutorSubscribableChannel.class, argValues, null);
        ManagedList interceptors = new ManagedList();
        if (element != null) {
            Element interceptorsElement = DomUtils.getChildElementByTagName((Element)element, (String)"interceptors");
            interceptors.addAll(WebSocketNamespaceUtils.parseBeanSubElements(interceptorsElement, context));
        }
        interceptors.add((Object)new ImmutableMessageChannelInterceptor());
        channelDef.getPropertyValues().add("interceptors", (Object)interceptors);
        MessageBrokerBeanDefinitionParser.registerBeanDefByName(name, channelDef, context, source);
        return new RuntimeBeanReference(name);
    }

    private RootBeanDefinition getDefaultExecutorBeanDefinition(String channelName) {
        if (channelName.equals("brokerChannel")) {
            return null;
        }
        RootBeanDefinition executorDef = new RootBeanDefinition(ThreadPoolTaskExecutor.class);
        executorDef.getPropertyValues().add("corePoolSize", (Object)(Runtime.getRuntime().availableProcessors() * 2));
        executorDef.getPropertyValues().add("maxPoolSize", (Object)Integer.MAX_VALUE);
        executorDef.getPropertyValues().add("queueCapacity", (Object)Integer.MAX_VALUE);
        executorDef.getPropertyValues().add("allowCoreThreadTimeOut", (Object)true);
        return executorDef;
    }

    private RuntimeBeanReference registerSubProtoHandler(Element element, RuntimeBeanReference inChannel, RuntimeBeanReference outChannel, RuntimeBeanReference registry, ParserContext context, Object source) {
        RootBeanDefinition stompHandlerDef = new RootBeanDefinition(StompSubProtocolHandler.class);
        stompHandlerDef.getPropertyValues().add("userSessionRegistry", (Object)registry);
        MessageBrokerBeanDefinitionParser.registerBeanDef(stompHandlerDef, context, source);
        ConstructorArgumentValues cavs = new ConstructorArgumentValues();
        cavs.addIndexedArgumentValue(0, (Object)inChannel);
        cavs.addIndexedArgumentValue(1, (Object)outChannel);
        RootBeanDefinition handlerDef = new RootBeanDefinition(SubProtocolWebSocketHandler.class, cavs, null);
        handlerDef.getPropertyValues().addPropertyValue("protocolHandlers", (Object)stompHandlerDef);
        MessageBrokerBeanDefinitionParser.registerBeanDefByName(WEB_SOCKET_HANDLER_BEAN_NAME, handlerDef, context, source);
        RuntimeBeanReference result = new RuntimeBeanReference(WEB_SOCKET_HANDLER_BEAN_NAME);
        Element transportElem = DomUtils.getChildElementByTagName((Element)element, (String)"transport");
        if (transportElem != null) {
            Element factoriesElement;
            if (transportElem.hasAttribute("message-size")) {
                stompHandlerDef.getPropertyValues().add("messageSizeLimit", (Object)transportElem.getAttribute("message-size"));
            }
            if (transportElem.hasAttribute("send-timeout")) {
                handlerDef.getPropertyValues().add("sendTimeLimit", (Object)transportElem.getAttribute("send-timeout"));
            }
            if (transportElem.hasAttribute("send-buffer-size")) {
                handlerDef.getPropertyValues().add("sendBufferSizeLimit", (Object)transportElem.getAttribute("send-buffer-size"));
            }
            if ((factoriesElement = DomUtils.getChildElementByTagName((Element)transportElem, (String)"decorator-factories")) != null) {
                ManagedList<Object> factories = this.extractBeanSubElements(factoriesElement, context);
                RootBeanDefinition factoryBean = new RootBeanDefinition(DecoratingFactoryBean.class);
                factoryBean.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)handlerDef);
                factoryBean.getConstructorArgumentValues().addIndexedArgumentValue(1, factories);
                result = new RuntimeBeanReference(MessageBrokerBeanDefinitionParser.registerBeanDef(factoryBean, context, source));
            }
        }
        return result;
    }

    private RuntimeBeanReference registerRequestHandler(Element element, RuntimeBeanReference subProtoHandler, ParserContext context, Object source) {
        RootBeanDefinition beanDef;
        RuntimeBeanReference sockJsService = WebSocketNamespaceUtils.registerSockJsService(element, SOCKJS_SCHEDULER_BEAN_NAME, context, source);
        if (sockJsService != null) {
            ConstructorArgumentValues cavs = new ConstructorArgumentValues();
            cavs.addIndexedArgumentValue(0, (Object)sockJsService);
            cavs.addIndexedArgumentValue(1, (Object)subProtoHandler);
            beanDef = new RootBeanDefinition(SockJsHttpRequestHandler.class, cavs, null);
        } else {
            RuntimeBeanReference handshakeHandler = WebSocketNamespaceUtils.registerHandshakeHandler(element, context, source);
            Element interceptorsElement = DomUtils.getChildElementByTagName((Element)element, (String)"handshake-interceptors");
            ManagedList<? super Object> interceptors = WebSocketNamespaceUtils.parseBeanSubElements(interceptorsElement, context);
            String allowedOriginsAttribute = element.getAttribute("allowed-origins");
            List<String> allowedOrigins = Arrays.asList(StringUtils.tokenizeToStringArray((String)allowedOriginsAttribute, (String)","));
            if (!allowedOrigins.isEmpty()) {
                OriginHandshakeInterceptor interceptor = new OriginHandshakeInterceptor();
                interceptor.setAllowedOrigins(allowedOrigins);
                interceptors.add((Object)interceptor);
            }
            ConstructorArgumentValues cavs = new ConstructorArgumentValues();
            cavs.addIndexedArgumentValue(0, (Object)subProtoHandler);
            if (handshakeHandler != null) {
                cavs.addIndexedArgumentValue(1, (Object)handshakeHandler);
            }
            beanDef = new RootBeanDefinition(WebSocketHttpRequestHandler.class, cavs, null);
            beanDef.getPropertyValues().add("handshakeInterceptors", interceptors);
        }
        return new RuntimeBeanReference(MessageBrokerBeanDefinitionParser.registerBeanDef(beanDef, context, source));
    }

    private RootBeanDefinition registerMessageBroker(Element messageBrokerElement, RuntimeBeanReference inChannel, RuntimeBeanReference outChannel, RuntimeBeanReference brokerChannel, ParserContext context, Object source) {
        RootBeanDefinition brokerDef;
        Element simpleBrokerElem = DomUtils.getChildElementByTagName((Element)messageBrokerElement, (String)"simple-broker");
        Element brokerRelayElem = DomUtils.getChildElementByTagName((Element)messageBrokerElement, (String)"stomp-broker-relay");
        ConstructorArgumentValues cavs = new ConstructorArgumentValues();
        cavs.addIndexedArgumentValue(0, (Object)inChannel);
        cavs.addIndexedArgumentValue(1, (Object)outChannel);
        cavs.addIndexedArgumentValue(2, (Object)brokerChannel);
        if (simpleBrokerElem != null) {
            String prefix = simpleBrokerElem.getAttribute("prefix");
            cavs.addIndexedArgumentValue(3, Arrays.asList(StringUtils.tokenizeToStringArray((String)prefix, (String)",")));
            brokerDef = new RootBeanDefinition(SimpleBrokerMessageHandler.class, cavs, null);
            if (messageBrokerElement.hasAttribute("path-matcher")) {
                String pathMatcherRef = messageBrokerElement.getAttribute("path-matcher");
                brokerDef.getPropertyValues().add("pathMatcher", (Object)new RuntimeBeanReference(pathMatcherRef));
            }
        } else if (brokerRelayElem != null) {
            String prefix = brokerRelayElem.getAttribute("prefix");
            cavs.addIndexedArgumentValue(3, Arrays.asList(StringUtils.tokenizeToStringArray((String)prefix, (String)",")));
            MutablePropertyValues values = new MutablePropertyValues();
            if (brokerRelayElem.hasAttribute("relay-host")) {
                values.add("relayHost", (Object)brokerRelayElem.getAttribute("relay-host"));
            }
            if (brokerRelayElem.hasAttribute("relay-port")) {
                values.add("relayPort", (Object)brokerRelayElem.getAttribute("relay-port"));
            }
            if (brokerRelayElem.hasAttribute("client-login")) {
                values.add("clientLogin", (Object)brokerRelayElem.getAttribute("client-login"));
            }
            if (brokerRelayElem.hasAttribute("client-passcode")) {
                values.add("clientPasscode", (Object)brokerRelayElem.getAttribute("client-passcode"));
            }
            if (brokerRelayElem.hasAttribute("system-login")) {
                values.add("systemLogin", (Object)brokerRelayElem.getAttribute("system-login"));
            }
            if (brokerRelayElem.hasAttribute("system-passcode")) {
                values.add("systemPasscode", (Object)brokerRelayElem.getAttribute("system-passcode"));
            }
            if (brokerRelayElem.hasAttribute("heartbeat-send-interval")) {
                values.add("systemHeartbeatSendInterval", (Object)brokerRelayElem.getAttribute("heartbeat-send-interval"));
            }
            if (brokerRelayElem.hasAttribute("heartbeat-receive-interval")) {
                values.add("systemHeartbeatReceiveInterval", (Object)brokerRelayElem.getAttribute("heartbeat-receive-interval"));
            }
            if (brokerRelayElem.hasAttribute("virtual-host")) {
                values.add("virtualHost", (Object)brokerRelayElem.getAttribute("virtual-host"));
            }
            Class<StompBrokerRelayMessageHandler> handlerType = StompBrokerRelayMessageHandler.class;
            brokerDef = new RootBeanDefinition(handlerType, cavs, values);
        } else {
            throw new IllegalStateException("Neither <simple-broker> nor <stomp-broker-relay> elements found.");
        }
        MessageBrokerBeanDefinitionParser.registerBeanDef(brokerDef, context, source);
        return brokerDef;
    }

    private RuntimeBeanReference registerMessageConverter(Element element, ParserContext context, Object source) {
        Element convertersElement = DomUtils.getChildElementByTagName((Element)element, (String)"message-converters");
        ManagedList converters = new ManagedList();
        if (convertersElement != null) {
            converters.setSource(source);
            for (Element beanElement : DomUtils.getChildElementsByTagName((Element)convertersElement, (String[])new String[]{"bean", "ref"})) {
                Object object = context.getDelegate().parsePropertySubElement(beanElement, null);
                converters.add(object);
            }
        }
        if (convertersElement == null || Boolean.valueOf(convertersElement.getAttribute("register-defaults")).booleanValue()) {
            converters.setSource(source);
            converters.add((Object)new RootBeanDefinition(StringMessageConverter.class));
            converters.add((Object)new RootBeanDefinition(ByteArrayMessageConverter.class));
            if (jackson2Present) {
                RootBeanDefinition jacksonConverterDef = new RootBeanDefinition(MappingJackson2MessageConverter.class);
                RootBeanDefinition resolverDef = new RootBeanDefinition(DefaultContentTypeResolver.class);
                resolverDef.getPropertyValues().add("defaultMimeType", (Object)MimeTypeUtils.APPLICATION_JSON);
                jacksonConverterDef.getPropertyValues().add("contentTypeResolver", (Object)resolverDef);
                GenericBeanDefinition jacksonFactoryDef = new GenericBeanDefinition();
                jacksonFactoryDef.setBeanClass(Jackson2ObjectMapperFactoryBean.class);
                jacksonFactoryDef.setRole(2);
                jacksonFactoryDef.setSource(source);
                jacksonConverterDef.getPropertyValues().add("objectMapper", (Object)jacksonFactoryDef);
                converters.add((Object)jacksonConverterDef);
            }
        }
        ConstructorArgumentValues cavs = new ConstructorArgumentValues();
        cavs.addIndexedArgumentValue(0, (Object)converters);
        RootBeanDefinition messageConverterDef = new RootBeanDefinition(CompositeMessageConverter.class, cavs, null);
        return new RuntimeBeanReference(MessageBrokerBeanDefinitionParser.registerBeanDef(messageConverterDef, context, source));
    }

    private RuntimeBeanReference registerMessagingTemplate(Element element, RuntimeBeanReference brokerChannel, RuntimeBeanReference messageConverter, ParserContext context, Object source) {
        ConstructorArgumentValues cavs = new ConstructorArgumentValues();
        cavs.addIndexedArgumentValue(0, (Object)brokerChannel);
        RootBeanDefinition beanDef = new RootBeanDefinition(SimpMessagingTemplate.class, cavs, null);
        if (element.hasAttribute("user-destination-prefix")) {
            beanDef.getPropertyValues().add("userDestinationPrefix", (Object)element.getAttribute("user-destination-prefix"));
        }
        beanDef.getPropertyValues().add("messageConverter", (Object)messageConverter);
        return new RuntimeBeanReference(MessageBrokerBeanDefinitionParser.registerBeanDef(beanDef, context, source));
    }

    private void registerAnnotationMethodMessageHandler(Element messageBrokerElement, RuntimeBeanReference inChannel, RuntimeBeanReference outChannel, RuntimeBeanReference converter, RuntimeBeanReference messagingTemplate, ParserContext context, Object source) {
        Element handlersElement;
        Element resolversElement;
        ConstructorArgumentValues cavs = new ConstructorArgumentValues();
        cavs.addIndexedArgumentValue(0, (Object)inChannel);
        cavs.addIndexedArgumentValue(1, (Object)outChannel);
        cavs.addIndexedArgumentValue(2, (Object)messagingTemplate);
        MutablePropertyValues values = new MutablePropertyValues();
        String prefixAttribute = messageBrokerElement.getAttribute("application-destination-prefix");
        values.add("destinationPrefixes", Arrays.asList(StringUtils.tokenizeToStringArray((String)prefixAttribute, (String)",")));
        values.add("messageConverter", (Object)converter);
        RootBeanDefinition beanDef = new RootBeanDefinition(SimpAnnotationMethodMessageHandler.class, cavs, values);
        if (messageBrokerElement.hasAttribute("path-matcher")) {
            String pathMatcherRef = messageBrokerElement.getAttribute("path-matcher");
            beanDef.getPropertyValues().add("pathMatcher", (Object)new RuntimeBeanReference(pathMatcherRef));
        }
        if ((resolversElement = DomUtils.getChildElementByTagName((Element)messageBrokerElement, (String)"argument-resolvers")) != null) {
            values.add("customArgumentResolvers", this.extractBeanSubElements(resolversElement, context));
        }
        if ((handlersElement = DomUtils.getChildElementByTagName((Element)messageBrokerElement, (String)"return-value-handlers")) != null) {
            values.add("customReturnValueHandlers", this.extractBeanSubElements(handlersElement, context));
        }
        MessageBrokerBeanDefinitionParser.registerBeanDef(beanDef, context, source);
    }

    private ManagedList<Object> extractBeanSubElements(Element parentElement, ParserContext parserContext) {
        ManagedList list = new ManagedList();
        list.setSource(parserContext.extractSource((Object)parentElement));
        for (Element beanElement : DomUtils.getChildElementsByTagName((Element)parentElement, (String[])new String[]{"bean", "ref"})) {
            Object object = parserContext.getDelegate().parsePropertySubElement(beanElement, null);
            list.add(object);
        }
        return list;
    }

    private RuntimeBeanReference registerUserDestinationResolver(Element brokerElem, RuntimeBeanReference userSessionRegistry, ParserContext context, Object source) {
        ConstructorArgumentValues cavs = new ConstructorArgumentValues();
        cavs.addIndexedArgumentValue(0, (Object)userSessionRegistry);
        RootBeanDefinition beanDef = new RootBeanDefinition(DefaultUserDestinationResolver.class, cavs, null);
        if (brokerElem.hasAttribute("user-destination-prefix")) {
            beanDef.getPropertyValues().add("userDestinationPrefix", (Object)brokerElem.getAttribute("user-destination-prefix"));
        }
        return new RuntimeBeanReference(MessageBrokerBeanDefinitionParser.registerBeanDef(beanDef, context, source));
    }

    private RuntimeBeanReference registerUserDestinationMessageHandler(RuntimeBeanReference inChannel, RuntimeBeanReference brokerChannel, RuntimeBeanReference userDestinationResolver, ParserContext context, Object source) {
        ConstructorArgumentValues cavs = new ConstructorArgumentValues();
        cavs.addIndexedArgumentValue(0, (Object)inChannel);
        cavs.addIndexedArgumentValue(1, (Object)brokerChannel);
        cavs.addIndexedArgumentValue(2, (Object)userDestinationResolver);
        RootBeanDefinition beanDef = new RootBeanDefinition(UserDestinationMessageHandler.class, cavs, null);
        return new RuntimeBeanReference(MessageBrokerBeanDefinitionParser.registerBeanDef(beanDef, context, source));
    }

    private void registerWebSocketMessageBrokerStats(RootBeanDefinition broker, RuntimeBeanReference inChannel, RuntimeBeanReference outChannel, ParserContext context, Object source) {
        RootBeanDefinition beanDef = new RootBeanDefinition(WebSocketMessageBrokerStats.class);
        RuntimeBeanReference webSocketHandler = new RuntimeBeanReference(WEB_SOCKET_HANDLER_BEAN_NAME);
        beanDef.getPropertyValues().add(WEB_SOCKET_HANDLER_BEAN_NAME, (Object)webSocketHandler);
        if (StompBrokerRelayMessageHandler.class.equals((Object)broker.getBeanClass())) {
            beanDef.getPropertyValues().add("stompBrokerRelay", (Object)broker);
        }
        String name = inChannel.getBeanName() + "Executor";
        if (context.getRegistry().containsBeanDefinition(name)) {
            beanDef.getPropertyValues().add("inboundChannelExecutor", (Object)context.getRegistry().getBeanDefinition(name));
        }
        name = outChannel.getBeanName() + "Executor";
        if (context.getRegistry().containsBeanDefinition(name)) {
            beanDef.getPropertyValues().add("outboundChannelExecutor", (Object)context.getRegistry().getBeanDefinition(name));
        }
        name = SOCKJS_SCHEDULER_BEAN_NAME;
        if (context.getRegistry().containsBeanDefinition(name)) {
            beanDef.getPropertyValues().add("sockJsTaskScheduler", (Object)context.getRegistry().getBeanDefinition(name));
        }
        MessageBrokerBeanDefinitionParser.registerBeanDefByName("webSocketMessageBrokerStats", beanDef, context, source);
    }

    private static String registerBeanDef(RootBeanDefinition beanDef, ParserContext context, Object source) {
        String name = context.getReaderContext().generateBeanName((BeanDefinition)beanDef);
        MessageBrokerBeanDefinitionParser.registerBeanDefByName(name, beanDef, context, source);
        return name;
    }

    private static void registerBeanDefByName(String name, RootBeanDefinition beanDef, ParserContext context, Object source) {
        beanDef.setSource(source);
        beanDef.setRole(2);
        context.getRegistry().registerBeanDefinition(name, (BeanDefinition)beanDef);
        context.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)beanDef, name));
    }

    private static class DecoratingFactoryBean
    implements FactoryBean<WebSocketHandler> {
        private final WebSocketHandler handler;
        private final List<WebSocketHandlerDecoratorFactory> factories;

        private DecoratingFactoryBean(WebSocketHandler handler, List<WebSocketHandlerDecoratorFactory> factories) {
            this.handler = handler;
            this.factories = factories;
        }

        public WebSocketHandler getObject() throws Exception {
            WebSocketHandler result = this.handler;
            for (WebSocketHandlerDecoratorFactory factory : this.factories) {
                result = factory.decorate(result);
            }
            return result;
        }

        public Class<?> getObjectType() {
            return WebSocketHandler.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

