/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.net.URI;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.web.client.ApiVersionFormatter;
import org.springframework.web.client.DefaultApiVersionInserterBuilder;

public interface ApiVersionInserter {
    default public URI insertVersion(Object version, URI uri) {
        return uri;
    }

    default public void insertVersion(Object version, HttpHeaders headers) {
    }

    public static Builder fromHeader(@Nullable String header) {
        return new DefaultApiVersionInserterBuilder(header, null, null);
    }

    public static Builder fromQueryParam(@Nullable String queryParam) {
        return new DefaultApiVersionInserterBuilder(null, queryParam, null);
    }

    public static Builder fromPathSegment(@Nullable Integer pathSegmentIndex) {
        return new DefaultApiVersionInserterBuilder(null, null, pathSegmentIndex);
    }

    public static interface Builder {
        public Builder fromHeader(@Nullable String var1);

        public Builder fromQueryParam(@Nullable String var1);

        public Builder fromPathSegment(@Nullable Integer var1);

        public Builder withVersionFormatter(ApiVersionFormatter var1);

        public ApiVersionInserter build();
    }
}

