/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.springframework.beans.BeanUtils;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.test.context.support.AbstractDelegatingSmartContextLoader;
import org.springframework.test.context.support.AnnotationConfigContextLoader;
import org.springframework.test.context.support.GenericXmlContextLoader;
import org.springframework.util.ClassUtils;

public class DelegatingSmartContextLoader
extends AbstractDelegatingSmartContextLoader {
    private static final String GROOVY_XML_CONTEXT_LOADER_CLASS_NAME = "org.springframework.test.context.support.GenericGroovyXmlContextLoader";
    private static final boolean GROOVY_PRESENT = ClassUtils.isPresent((String)"groovy.lang.Closure", (ClassLoader)DelegatingSmartContextLoader.class.getClassLoader()) && ClassUtils.isPresent((String)"org.springframework.test.context.support.GenericGroovyXmlContextLoader", (ClassLoader)DelegatingSmartContextLoader.class.getClassLoader());
    private final SmartContextLoader xmlLoader;
    private final SmartContextLoader annotationConfigLoader;

    public DelegatingSmartContextLoader() {
        if (GROOVY_PRESENT) {
            try {
                Class loaderClass = ClassUtils.forName((String)GROOVY_XML_CONTEXT_LOADER_CLASS_NAME, (ClassLoader)DelegatingSmartContextLoader.class.getClassLoader());
                this.xmlLoader = (SmartContextLoader)BeanUtils.instantiateClass((Class)loaderClass);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to enable support for Groovy scripts; could not load class: org.springframework.test.context.support.GenericGroovyXmlContextLoader", ex);
            }
        } else {
            this.xmlLoader = new GenericXmlContextLoader();
        }
        this.annotationConfigLoader = new AnnotationConfigContextLoader();
    }

    @Override
    protected SmartContextLoader getXmlLoader() {
        return this.xmlLoader;
    }

    @Override
    protected SmartContextLoader getAnnotationConfigLoader() {
        return this.annotationConfigLoader;
    }
}

