/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationConfigContextLoaderUtils {
    private static final Log logger = LogFactory.getLog(AnnotationConfigContextLoaderUtils.class);

    private static boolean isDefaultConfigurationClassCandidate(Class<?> clazz) {
        return clazz != null && AnnotationConfigContextLoaderUtils.isStaticNonPrivateAndNonFinal(clazz) && clazz.isAnnotationPresent(Configuration.class);
    }

    private static boolean isStaticNonPrivateAndNonFinal(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Class must not be null");
        int modifiers = clazz.getModifiers();
        return Modifier.isStatic(modifiers) && !Modifier.isPrivate(modifiers) && !Modifier.isFinal(modifiers);
    }

    public static Class<?>[] detectDefaultConfigurationClasses(Class<?> declaringClass) {
        Assert.notNull(declaringClass, (String)"Declaring class must not be null");
        ArrayList configClasses = new ArrayList();
        for (Class<?> candidate : declaringClass.getDeclaredClasses()) {
            if (AnnotationConfigContextLoaderUtils.isDefaultConfigurationClassCandidate(candidate)) {
                configClasses.add(candidate);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)String.format("Ignoring class [%s]; it must be static, non-private, non-final, and annotated with @Configuration to be considered a default configuration class.", candidate.getName()));
        }
        if (configClasses.isEmpty() && logger.isInfoEnabled()) {
            logger.info((Object)String.format("Could not detect default configuration classes for test class [%s]: %s does not declare any static, non-private, non-final, inner classes annotated with @Configuration.", declaringClass.getName(), declaringClass.getSimpleName()));
        }
        return configClasses.toArray(new Class[configClasses.size()]);
    }
}

