/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.messaging.simp.stomp.StompEncoder;
import org.springframework.util.Assert;

public class SplittingStompEncoder {
    private final StompEncoder encoder;
    private final int bufferSizeLimit;

    public SplittingStompEncoder(StompEncoder encoder, int bufferSizeLimit) {
        Assert.notNull((Object)encoder, (String)"StompEncoder is required");
        Assert.isTrue((bufferSizeLimit > 0 ? 1 : 0) != 0, (String)"Buffer size limit must be greater than 0");
        this.encoder = encoder;
        this.bufferSizeLimit = bufferSizeLimit;
    }

    public List<byte[]> encode(Map<String, Object> headers, byte[] payload) {
        byte[] result = this.encoder.encode(headers, payload);
        int length = result.length;
        if (length <= this.bufferSizeLimit) {
            return List.of(result);
        }
        ArrayList<byte[]> frames = new ArrayList<byte[]>();
        for (int i2 = 0; i2 < length; i2 += this.bufferSizeLimit) {
            frames.add(Arrays.copyOfRange(result, i2, Math.min(i2 + this.bufferSizeLimit, length)));
        }
        return frames;
    }
}

