/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.support.SqlValue;
import org.springframework.util.Assert;

public class SqlArrayValue
implements SqlValue {
    private final String typeName;
    private final Object[] elements;
    private @Nullable Array array;

    public SqlArrayValue(String typeName, Object ... elements) {
        Assert.notNull((Object)typeName, (String)"Type name must not be null");
        Assert.notNull((Object)elements, (String)"Elements array must not be null");
        this.typeName = typeName;
        this.elements = elements;
    }

    @Override
    public void setValue(PreparedStatement ps, int paramIndex) throws SQLException {
        this.array = ps.getConnection().createArrayOf(this.typeName, this.elements);
        ps.setArray(paramIndex, this.array);
    }

    @Override
    public void cleanup() {
        if (this.array != null) {
            try {
                this.array.free();
            }
            catch (SQLException ex) {
                throw new DataAccessResourceFailureException("Could not free Array object", (Throwable)ex);
            }
        }
    }
}

