/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.SQLException;
import java.util.Set;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator;
import org.springframework.lang.Nullable;

public class SQLStateSQLExceptionTranslator
extends AbstractFallbackSQLExceptionTranslator {
    private static final Set<String> BAD_SQL_GRAMMAR_CODES = Set.of("07", "21", "2A", "37", "42", "65");
    private static final Set<String> DATA_INTEGRITY_VIOLATION_CODES = Set.of("01", "02", "22", "23", "27", "44");
    private static final Set<String> DATA_ACCESS_RESOURCE_FAILURE_CODES = Set.of("08", "53", "54", "57", "58");
    private static final Set<String> TRANSIENT_DATA_ACCESS_RESOURCE_CODES = Set.of("JW", "JZ", "S1");
    private static final Set<String> PESSIMISTIC_LOCKING_FAILURE_CODES = Set.of("40", "61");

    @Override
    @Nullable
    protected DataAccessException doTranslate(String task, @Nullable String sql, SQLException ex) {
        String sqlState = this.getSqlState(ex);
        if (sqlState != null && sqlState.length() >= 2) {
            String classCode = sqlState.substring(0, 2);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Extracted SQL state class '" + classCode + "' from value '" + sqlState + "'"));
            }
            if (BAD_SQL_GRAMMAR_CODES.contains(classCode)) {
                return new BadSqlGrammarException(task, sql != null ? sql : "", ex);
            }
            if (DATA_INTEGRITY_VIOLATION_CODES.contains(classCode)) {
                if (SQLStateSQLExceptionTranslator.indicatesDuplicateKey(sqlState, ex.getErrorCode())) {
                    return new DuplicateKeyException(this.buildMessage(task, sql, ex), (Throwable)ex);
                }
                return new DataIntegrityViolationException(this.buildMessage(task, sql, ex), (Throwable)ex);
            }
            if (DATA_ACCESS_RESOURCE_FAILURE_CODES.contains(classCode)) {
                return new DataAccessResourceFailureException(this.buildMessage(task, sql, ex), (Throwable)ex);
            }
            if (TRANSIENT_DATA_ACCESS_RESOURCE_CODES.contains(classCode)) {
                return new TransientDataAccessResourceException(this.buildMessage(task, sql, ex), (Throwable)ex);
            }
            if (PESSIMISTIC_LOCKING_FAILURE_CODES.contains(classCode)) {
                if ("40001".equals(sqlState)) {
                    return new CannotAcquireLockException(this.buildMessage(task, sql, ex), (Throwable)ex);
                }
                return new PessimisticLockingFailureException(this.buildMessage(task, sql, ex), (Throwable)ex);
            }
        }
        if (ex.getClass().getName().contains("Timeout")) {
            return new QueryTimeoutException(this.buildMessage(task, sql, ex), (Throwable)ex);
        }
        return null;
    }

    @Nullable
    private String getSqlState(SQLException ex) {
        SQLException nestedEx;
        String sqlState = ex.getSQLState();
        if (sqlState == null && (nestedEx = ex.getNextException()) != null) {
            sqlState = nestedEx.getSQLState();
        }
        return sqlState;
    }

    static boolean indicatesDuplicateKey(@Nullable String sqlState, int errorCode) {
        return "23505".equals(sqlState) || "23000".equals(sqlState) && (errorCode == 1 || errorCode == 1062 || errorCode == 2627);
    }
}

