/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import com.mchange.v2.c3p0.C3P0ProxyConnection;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;
import org.springframework.util.ReflectionUtils;

public class C3P0NativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private final Method getRawConnectionMethod;
    static /* synthetic */ Class class$java$sql$Connection;

    public static Connection getRawConnection(Connection con) {
        return con;
    }

    public C3P0NativeJdbcExtractor() {
        try {
            this.getRawConnectionMethod = this.getClass().getMethod("getRawConnection", class$java$sql$Connection == null ? (class$java$sql$Connection = C3P0NativeJdbcExtractor.class$("java.sql.Connection")) : class$java$sql$Connection);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Internal error in C3P0NativeJdbcExtractor: " + ex.getMessage());
        }
    }

    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return true;
    }

    protected Connection doGetNativeConnection(Connection con) throws SQLException {
        if (con instanceof C3P0ProxyConnection) {
            C3P0ProxyConnection cpCon = (C3P0ProxyConnection)con;
            try {
                return (Connection)cpCon.rawConnectionOperation(this.getRawConnectionMethod, null, new Object[]{C3P0ProxyConnection.RAW_CONNECTION});
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
        }
        return con;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

