/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class ReflectiveLoadTimeWeaver
implements LoadTimeWeaver {
    private static final String ADD_TRANSFORMER_METHOD_NAME = "addTransformer";
    private static final String GET_THROWAWAY_CLASS_LOADER_METHOD_NAME = "getThrowawayClassLoader";
    private static final Log log = LogFactory.getLog(ReflectiveLoadTimeWeaver.class);
    private final ClassLoader classLoader;
    private final Method addTransformerMethod;
    private final Method getThrowawayClassLoaderMethod;

    public ReflectiveLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public ReflectiveLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, (String)"ClassLoader must not be null");
        this.classLoader = classLoader;
        this.addTransformerMethod = ClassUtils.getMethodIfAvailable(this.classLoader.getClass(), (String)ADD_TRANSFORMER_METHOD_NAME, (Class[])new Class[]{ClassFileTransformer.class});
        if (this.addTransformerMethod == null) {
            throw new IllegalStateException("ClassLoader [" + classLoader + "|" + classLoader.getClass() + "] does not have an addTransformer(ClassFileTransformer) method");
        }
        this.getThrowawayClassLoaderMethod = ClassUtils.getMethodIfAvailable(this.classLoader.getClass(), (String)GET_THROWAWAY_CLASS_LOADER_METHOD_NAME, (Class[])new Class[0]);
        if (this.getThrowawayClassLoaderMethod == null) {
            log.warn((Object)("the current classloader " + classLoader + " does NOT have a getThrowawayClassLoader method; SimpleThrowawayClassLoader will be used instead"));
        }
    }

    public void addTransformer(ClassFileTransformer transformer) {
        Assert.notNull((Object)transformer, (String)"Transformer must not be null");
        ReflectionUtils.invokeMethod((Method)this.addTransformerMethod, (Object)this.classLoader, (Object[])new Object[]{transformer});
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getThrowawayClassLoader() {
        if (this.getThrowawayClassLoaderMethod != null) {
            return (ClassLoader)ReflectionUtils.invokeMethod((Method)this.getThrowawayClassLoaderMethod, (Object)this.classLoader, (Object[])new Object[0]);
        }
        return new SimpleThrowawayClassLoader(this.classLoader);
    }
}

